/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.tracker;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.dto.list.Enumerator;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.TextInput;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XPathLocationParser
implements ContentHandler {
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private XMLReader reader;
    private Locator locator;
    private final SimpleXPath find;
    private SimpleXPath current;
    private SimpleXPath summary;
    private TextInput xml;
    private final List elements;
    private int level;

    public XPathLocationParser(String xpath) throws ParserConfigurationException, SAXException {
        this.find = new SimpleXPath(xpath);
        this.elements = new ArrayList(20);
        this.level = 0;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setFeature(NAMESPACES_FEATURE_ID, false);
        factory.setFeature(VALIDATION_FEATURE_ID, false);
        SAXParser parser = factory.newSAXParser();
        this.reader = parser.getXMLReader();
        this.reader.setFeature(NAMESPACES_FEATURE_ID, false);
        this.reader.setFeature(VALIDATION_FEATURE_ID, false);
    }

    public final void parse(String fileName, URL original) throws SAXException, IOException {
        File file = new File(fileName);
        this.parse(file, original);
    }

    public final void parse(File file, URL original) throws SAXException, IOException {
        TextInput source = new TextInput(file, original);
        this.parse(source);
    }

    public final void parse(TextInput input) throws SAXException, IOException {
        this.xml = input;
        this.elements.clear();
        this.level = 0;
        try {
            this.current = new SimpleXPath();
            this.summary = new SimpleXPath();
            this.reader.setContentHandler(this);
            this.reader.parse(new InputSource(input.getLocalAddress().openStream()));
            this.xml = null;
        }
        catch (SAXException e) {
            Trace.trace((Object)this, "parse", (Throwable)e);
            throw e;
        }
    }

    public void endDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void startDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String method = "startElement(String, String, Attributes)";
        ++this.level;
        this.summary.addElement("*", this.addOccurence("*"));
        this.current.addElement(qName, this.addOccurence(qName));
        if (this.find.matchesElements(this.current, this.summary)) {
            Trace.trace((Object)this, "startElement(String, String, Attributes)", (Object)"matching elements");
            Trace.param((Object)this, "startElement(String, String, Attributes)", qName, (Object)this.current);
            this.xml.setRow(this.locator.getLineNumber());
            this.xml.setColumn(this.locator.getColumnNumber());
            try {
                this.xml.skipBackToBeginOfXmlTag();
            }
            catch (RuntimeException e) {
                Trace.trace((Object)this, "startElement(String, String, Attributes)", (Throwable)e);
            }
            this.find.setStartLocation(new SourcePosition(this.xml.getAddress(), this.xml.getRow(), this.xml.getColumn()));
            if (this.find.getAttribute() != null) {
                this.xml.read();
                this.xml.readNextXmlName();
                while (true) {
                    String tag;
                    this.xml.skipWhiteSpace();
                    int row = this.xml.getRow();
                    int col = this.xml.getColumn();
                    try {
                        tag = this.xml.readNextXmlName();
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                    if (tag.equals(this.find.getAttribute())) {
                        this.find.setStartLocation(new SourcePosition(this.xml.getAddress(), row, col));
                        this.xml.readNextAttributeValue();
                        this.find.setEndLocation(new SourcePosition(this.xml.getAddress(), this.xml.getRow(), this.xml.getColumn()));
                        break;
                    }
                    this.xml.readNextAttributeValue();
                }
            }
        }
    }

    private int addOccurence(String name) {
        Enumerator counter;
        while (this.level < this.elements.size()) {
            this.elements.remove(this.elements.size() - 1);
        }
        while (this.level > this.elements.size()) {
            this.elements.add(new HashMap());
        }
        Map levelMap = (Map)this.elements.get(this.level - 1);
        if (levelMap.containsKey(name)) {
            counter = (Enumerator)levelMap.get(name);
            counter.increaseNumber();
        } else {
            counter = new Enumerator(1);
            levelMap.put(name, counter);
        }
        return counter.getNumber();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        --this.level;
        if (this.find.matchesElements(this.current, this.summary) && this.find.getAttribute() == null) {
            this.xml.setRow(this.locator.getLineNumber());
            this.xml.setColumn(this.locator.getColumnNumber());
            this.find.setEndLocation(new SourcePosition(this.xml.getLocalAddress(), this.xml.getRow(), this.xml.getColumn()));
        }
        this.current.deleteLastElement();
        this.summary.deleteLastElement();
    }

    public SimpleXPath getFind() {
        return this.find;
    }
}

