/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.log;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.log.LogListener;
import org.qedeq.kernel.trace.Trace;

public final class QedeqLog
implements LogListener {
    private static QedeqLog instance = new QedeqLog();
    private List loggers = new ArrayList();

    public static final QedeqLog getInstance() {
        return instance;
    }

    private QedeqLog() {
    }

    public final void addLog(LogListener log) {
        this.loggers.add(log);
        Trace.paramInfo((Object)this, "addLog(LogListener)", "log", log.getClass());
    }

    public final void removeLog(LogListener log) {
        this.loggers.remove(log);
        Trace.paramInfo((Object)this, "removeLog(LogListener)", "log", log.getClass());
    }

    public void logMessageState(String text, URL url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logMessageState(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logMessageState", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }

    public void logFailureState(String text, URL url, String description) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logFailureState(text, url, description);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logFailureState", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }

    public void logSuccessfulState(String text, URL url) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logSuccessfulState(text, url);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logSuccessfulState", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }

    public void logRequest(String text) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logRequest(text);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logRequest", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }

    public void logSuccessfulReply(String text) {
        try {
            for (int i = 0; i < this.loggers.size(); ++i) {
                ((LogListener)this.loggers.get(i)).logSuccessfulReply(text);
            }
        }
        catch (RuntimeException e) {
            Trace.fatal(this, "logSuccessfulReply", "LogListener throwed RuntimeException", (Throwable)e);
        }
    }

    public void logFailureReply(String text, String description) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logFailureReply(text, description);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logFailureReply", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }

    public void logMessage(String text) {
        for (int i = 0; i < this.loggers.size(); ++i) {
            try {
                ((LogListener)this.loggers.get(i)).logMessage(text);
                continue;
            }
            catch (RuntimeException e) {
                Trace.fatal(this, "logMessage", "LogListener throwed RuntimeException", (Throwable)e);
            }
        }
    }
}

