/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.log;

import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.qedeq.kernel.log.LogListener;

public final class LogListenerImpl
implements LogListener {
    private PrintStream out = System.out;
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss,SSS");

    public LogListenerImpl() {
        this(System.out);
    }

    public LogListenerImpl(PrintStream stream) {
        this.out = stream;
    }

    public final void setPrintStream(PrintStream stream) {
        this.out = stream;
    }

    public final void logMessageState(String text, URL url) {
        this.out.println(LogListenerImpl.getTimestamp() + " state:   " + text + "\n\t" + url);
    }

    public final void logFailureState(String text, URL url, String description) {
        this.out.println(LogListenerImpl.getTimestamp() + " failure: " + text + "\n\t" + url + "\n\t" + description);
    }

    public final void logSuccessfulState(String text, URL url) {
        this.out.println(LogListenerImpl.getTimestamp() + " success: " + text + "\n\t" + url);
    }

    private static final String getTimestamp() {
        return FORMATTER.format(new Date()).toString();
    }

    public void logRequest(String text) {
        this.out.println(LogListenerImpl.getTimestamp() + " request: " + text);
    }

    public final void logMessage(String text) {
        this.out.println(LogListenerImpl.getTimestamp() + " " + text);
    }

    public void logSuccessfulReply(String text) {
        this.out.println(LogListenerImpl.getTimestamp() + " reply:   " + text);
    }

    public void logFailureReply(String text, String description) {
        this.out.println(LogListenerImpl.getTimestamp() + " reply:   " + text + "\n\t" + description);
    }
}

