/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.log;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.log.ModuleEventListener;

public class DefaultModuleEventListener
implements ModuleEventListener {
    private PrintStream out = System.out;
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss,SSS");

    public DefaultModuleEventListener() {
        this(System.out);
    }

    public DefaultModuleEventListener(PrintStream stream) {
        this.out = stream;
    }

    public final void setPrintStream(PrintStream stream) {
        this.out = stream;
    }

    public void addModule(ModuleProperties prop) {
        this.out.println(DefaultModuleEventListener.getTimestamp() + " Module added. " + prop.getStateDescription() + "\n\t" + prop.getAddress());
    }

    public void stateChanged(ModuleProperties prop) {
        this.out.println(DefaultModuleEventListener.getTimestamp() + " Module state changed. " + prop.getStateDescription() + "\n\t" + prop.getAddress());
    }

    public void removeModule(ModuleProperties prop) {
        this.out.println(DefaultModuleEventListener.getTimestamp() + " Module removed. " + prop.getStateDescription() + "\n\t" + prop.getAddress());
    }

    private static final String getTimestamp() {
        return FORMATTER.format(new Date()).toString();
    }
}

