/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.qedeq.kernel.config.ConfigAccess;

public class QedeqConfig {
    private static final String DEFAULT_LOCAL_MODULES_DIRECTORY = "local";
    private static final String DEFAULT_LOCAL_BUFFER = "buffer";
    private static final String DEFAULT_GENERATED = "generated";
    private static final String DEFAULT_LOG_FILE = "log/log.txt";
    private final ConfigAccess configAccess;
    private final File basisDirectory;

    public QedeqConfig(File configFile, String description, File basisDirectory) throws IOException {
        this.configAccess = new ConfigAccess(configFile, description);
        this.basisDirectory = basisDirectory;
    }

    public final void store() throws IOException {
        this.configAccess.store();
    }

    public final String getGenerationDirectory() {
        String location = this.getKeyValue("generationLocation");
        if (location == null) {
            return DEFAULT_GENERATED;
        }
        return location;
    }

    public final void setGenerationDirectory(String location) {
        this.setKeyValue("generationLocation", location);
    }

    public final String getBufferDirectory() {
        String location = this.getKeyValue("bufferLocation");
        if (location == null) {
            return DEFAULT_LOCAL_BUFFER;
        }
        return location;
    }

    public final void setBufferDirectory(String location) {
        this.setKeyValue("bufferLocation", location);
    }

    public final String getLogFile() {
        String location = this.getKeyValue("logLocation");
        if (location == null) {
            return DEFAULT_LOG_FILE;
        }
        return location;
    }

    public final String[] getModuleHistory() {
        return this.configAccess.getStringProperties("moduleHistory.");
    }

    public final void saveModuleHistory(List modules) {
        this.configAccess.removeProperties("moduleHistory.");
        for (int i = 0; i < modules.size(); ++i) {
            this.setKeyValue("moduleHistory." + (i + 101), modules.get(i).toString());
        }
    }

    public final String[] getPreviouslyCheckedModules() {
        return this.configAccess.getStringProperties("checkedModule.");
    }

    public final void setLoadedModules(URL[] moduleAddresses) {
        this.configAccess.removeProperties("checkedModule.");
        for (int i = 0; i < moduleAddresses.length; ++i) {
            this.setKeyValue("checkedModule." + (i + 1), moduleAddresses[i].toExternalForm());
        }
    }

    public final File getBasisDirectory() {
        return this.basisDirectory;
    }

    public final File getRelativeToBasis(String path) {
        return new File(this.getBasisDirectory(), path);
    }

    public boolean isAutoReloadLastSessionChecked() {
        return "true".equals(this.getKeyValue("sessionAutoReload", "true"));
    }

    public final void setAutoReloadLastSessionChecked(boolean mode) {
        this.setKeyValue("sessionAutoReload", mode ? "true" : "false");
    }

    public final boolean isOldHtml() {
        return "true".equals(this.getKeyValue("oldHtml", "true"));
    }

    public final void setOldHtml(boolean mode) {
        this.setKeyValue("oldHtml", mode ? "true" : "false");
    }

    public final String getLocalModulesDirectory() {
        String location = this.getKeyValue("localModulesDirectory");
        if (location == null) {
            return DEFAULT_LOCAL_MODULES_DIRECTORY;
        }
        return location;
    }

    public final void setLocalModulesDirectory(String location) {
        this.setKeyValue("localModulesDirectory", location);
    }

    protected String getKeyValue(String key) {
        return this.configAccess.getString(key);
    }

    protected String getKeyValue(String key, String defaultValue) {
        return this.configAccess.getString(key, defaultValue);
    }

    protected void setKeyValue(String key, String value) {
        this.configAccess.setString(key, value);
    }
}

