/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.qedeq.kernel.common.QedeqException;
import org.qedeq.kernel.common.SourceArea;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;
import org.qedeq.kernel.utility.TextInput;
import org.xml.sax.SAXException;

public class SourceFileException
extends QedeqException {
    private static final long serialVersionUID = -4109767904038020052L;
    private final SourceArea errorArea;
    private final SourceArea referenceArea;
    private String line;

    public SourceFileException(int errorCode, String errorText, Throwable exception, SourceArea errorArea, SourceArea referenceArea) {
        super(errorCode, errorText, exception);
        this.errorArea = errorArea;
        this.referenceArea = referenceArea;
    }

    public SourceFileException(QedeqException exception, SourceArea errorArea, SourceArea referenceArea) {
        this(exception.getErrorCode(), exception.getMessage(), exception, errorArea, referenceArea);
    }

    public SourceFileException(URL url, Exception exception) {
        super(9997, exception.getMessage(), exception);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public SourceFileException(File file, Exception exception) {
        super(9998, exception.getMessage(), exception);
        URL url = IoUtility.toUrl(file);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public SourceFileException(Exception exception) {
        super(9999, exception.getMessage(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceFileException(Throwable exception) {
        super(1000, exception.toString(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceFileException(IOException exception) {
        super(9997, exception.toString(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceFileException(SAXException exception) {
        super(9001, exception.getMessage(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public final SourceArea getSourceArea() {
        return this.errorArea;
    }

    public final SourceArea getReferenceArea() {
        return this.referenceArea;
    }

    public final String getLine(URL localAddress) {
        if (this.line == null) {
            this.line = "";
            try {
                TextInput input = new TextInput(localAddress);
                input.setRow(this.errorArea.getStartPosition().getLine());
                input.setColumn(this.errorArea.getStartPosition().getColumn());
                this.line = input.getLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.line;
    }

    public final String getMessage() {
        if (this.getCause() != null) {
            if (this.getCause().getCause() != null) {
                return this.getCause().getCause().getMessage();
            }
            return this.getCause().getMessage();
        }
        return "";
    }

    public final String getDescription(URL localAddress) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorCode() + ": " + this.getMessage());
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append("\n");
            buffer.append(start.getAddress() + ":" + start.getLine() + ":" + start.getColumn());
            buffer.append("\n");
            buffer.append(ReplaceUtility.replace(this.getLine(localAddress), "\t", " "));
            buffer.append("\n");
            StringBuffer whitespace = IoUtility.getSpaces(start.getColumn() - 1);
            buffer.append(whitespace);
            buffer.append("^");
        }
        return buffer.toString();
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorCode() + ": " + this.getMessage());
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append("\n");
            buffer.append(start.getAddress() + ":" + start.getLine() + ":" + start.getColumn());
        }
        return buffer.toString();
    }
}

