/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qedeq.kernel.bo.module.IllegalModuleDataException;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.utility.EqualsUtility;

public class ModuleReferenceList {
    private final List labels = new ArrayList();
    private final List addresses = new ArrayList();
    private final Map label2Context = new HashMap();

    public final void add(ModuleContext context, String label, URL address) throws IllegalModuleDataException {
        if (label == null || label.length() <= 0 || address == null) {
            throw new IllegalModuleDataException(10003, "An label was not defined.", context, null, null);
        }
        if (this.labels.contains(label)) {
            throw new IllegalModuleDataException(10004, "Label \"" + label + "\" defined more than once.", context, (ModuleContext)this.label2Context.get(label), null);
        }
        this.labels.add(label);
        this.addresses.add(address);
    }

    public final int size() {
        return this.labels.size();
    }

    public final String getLabel(int index) {
        return (String)this.labels.get(index);
    }

    public final URL getUrl(int index) {
        return (URL)this.addresses.get(index);
    }

    public final URL getUrl(ModuleContext context, String label) throws IllegalModuleDataException {
        int index = this.labels.indexOf(label);
        if (index < 0) {
            throw new IllegalModuleDataException(10005, "This module label \"" + label + "\"was not found.", context, null, null);
        }
        return (URL)this.addresses.get(index);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleReferenceList)) {
            return false;
        }
        ModuleReferenceList otherList = (ModuleReferenceList)obj;
        if (this.size() != otherList.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (EqualsUtility.equals(this.getLabel(i), otherList.getLabel(i)) && EqualsUtility.equals(this.getUrl(i), otherList.getUrl(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.size(); ++i) {
            hash ^= i + 1;
            if (this.getLabel(i) == null) continue;
            hash ^= this.getLabel(i).hashCode();
            hash ^= this.getUrl(i).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("module reference list:\n");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                buffer.append("\n");
            }
            buffer.append(i + 1 + ":\t");
            buffer.append(this.getLabel(i)).append(": ").append(this.getUrl(i)).append("\n");
        }
        return buffer.toString();
    }
}

