/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.module;

public final class DependencyState {
    public static final DependencyState STATE_UNDEFINED = new DependencyState("undefined", false, 0);
    public static final DependencyState STATE_LOADING_REQUIRED_MODULES = new DependencyState("loading required modules", false, 11);
    public static final DependencyState STATE_LOADING_REQUIRED_MODULES_FAILED = new DependencyState("loading required modules failed", true, 12);
    public static final DependencyState STATE_LOADING_REQUIRED_REQUIREMENTS = new DependencyState("loading required modules of required modules", false, 13);
    public static final DependencyState STATE_LOADING_REQUIRED_REQUIREMENTS_FAILED = new DependencyState("loading required modules of required modules failed", true, 14);
    public static final DependencyState STATE_LOADED_REQUIRED_MODULES = new DependencyState("loaded required modules", false, 15);
    private final String text;
    private final boolean failure;
    private final int code;

    private DependencyState(String text, boolean failure, int code) {
        this.text = text;
        if (this.text == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.failure = failure;
        this.code = code;
    }

    public final String getText() {
        return this.text;
    }

    public final boolean isFailure() {
        return this.failure;
    }

    public final boolean areAllRequiredLoaded() {
        return this.code == STATE_LOADED_REQUIRED_MODULES.getCode();
    }

    public final int getCode() {
        return this.code;
    }

    public final String toString() {
        return this.text;
    }

    public final int hashCode() {
        return this.text.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DependencyState)) {
            return false;
        }
        return this.text.equals(((DependencyState)obj).text);
    }
}

