/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qedeq.kernel.bo.load.DefaultModuleAddress;
import org.qedeq.kernel.bo.load.DefaultModuleProperties;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;

class Modules {
    private final Map moduleProperties = new HashMap();

    Modules() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ModuleProperties getModuleProperties(URL url) throws IOException {
        Map map = this.moduleProperties;
        synchronized (map) {
            DefaultModuleAddress address = new DefaultModuleAddress(url);
            if (this.moduleProperties.containsKey(address)) {
                return (ModuleProperties)this.moduleProperties.get(address);
            }
            DefaultModuleProperties prop = new DefaultModuleProperties(address);
            this.moduleProperties.put(address, prop);
            return prop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ModuleProperties getModuleProperties(ModuleAddress address) {
        Map map = this.moduleProperties;
        synchronized (map) {
            if (this.moduleProperties.containsKey(address)) {
                return (ModuleProperties)this.moduleProperties.get(address);
            }
            DefaultModuleProperties prop = new DefaultModuleProperties(address);
            this.moduleProperties.put(address, prop);
            return prop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeAllModules() {
        String method = "removeAllModules";
        Trace.begin(this, "removeAllModules");
        try {
            Map map = this.moduleProperties;
            synchronized (map) {
                Iterator iterator = this.moduleProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ModuleProperties prop = (ModuleProperties)entry.getValue();
                    Trace.trace((Object)this, "removeAllModules", (Object)("remove " + prop));
                    ModuleEventLog.getInstance().removeModule(prop);
                }
                this.moduleProperties.clear();
            }
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "removeAllModules", (Throwable)e);
        }
        finally {
            Trace.end(this, "removeAllModules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeModule(ModuleProperties prop) {
        String method = "removeModule";
        Trace.begin(this, "removeModule");
        try {
            Map map = this.moduleProperties;
            synchronized (map) {
                Trace.trace((Object)this, "removeModule", (Object)("remove module " + prop.getAddress()));
                if (!prop.isLoaded()) {
                    Trace.trace((Object)this, "removeModule", (Object)("removing " + prop.getAddress()));
                    ModuleEventLog.getInstance().removeModule(prop);
                    this.moduleProperties.remove(prop.getModuleAddress());
                } else {
                    Trace.trace((Object)this, "removeModule", (Object)("module number=" + this.moduleProperties.size()));
                    Trace.trace((Object)this, "removeModule", (Object)("removing module itself: " + prop.getAddress()));
                    ModuleEventLog.getInstance().removeModule(prop);
                    this.moduleProperties.remove(prop.getModuleAddress());
                    Trace.trace((Object)this, "removeModule", (Object)("module number=" + this.moduleProperties.size()));
                }
            }
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "removeModule", (Throwable)e);
        }
        finally {
            Trace.end(this, "removeModule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final URL[] getAllLoadedModules() {
        String method = "getAllModules";
        Trace.begin(this, "getAllModules");
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            URL[] uRLArray = this.moduleProperties;
            synchronized (this.moduleProperties) {
                Iterator iterator = this.moduleProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ModuleProperties prop = (ModuleProperties)entry.getValue();
                    if (prop.getLoadingState().getCode() < LoadingState.STATE_LOADED.getCode()) continue;
                    list.add(prop.getUrl());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                uRLArray = list.toArray(new URL[0]);
                return uRLArray;
            }
        }
        finally {
            Trace.end(this, "getAllModules");
        }
    }

    final int getNumberOfLoadedModules() {
        return this.getAllLoadedModules().length;
    }
}

