/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.net.URL;
import org.qedeq.kernel.bo.module.DependencyState;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.LogicalState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.ModuleReferenceList;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.SourceFileExceptionList;

public class DefaultModuleProperties
implements ModuleProperties {
    private final ModuleAddress address;
    private int loadingCompleteness;
    private LoadingState loadingState;
    private DependencyState dependencyState;
    private LogicalState logicalState;
    private QedeqBo module;
    private SourceFileExceptionList exception;
    private ModuleReferenceList required;

    public DefaultModuleProperties(ModuleAddress address) {
        this.address = address;
        this.loadingState = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.logicalState = LogicalState.STATE_UNCHECKED;
    }

    public final boolean hasFailures() {
        return this.loadingState.isFailure() || this.dependencyState.isFailure() || this.logicalState.isFailure();
    }

    public final String getAddress() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getAddress();
    }

    public final ModuleAddress getModuleAddress() {
        return this.address;
    }

    public final void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public final void setLoadingProgressState(LoadingState state) {
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState");
        }
        this.loadingState = state;
        this.module = null;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.logicalState = LogicalState.STATE_UNCHECKED;
        this.exception = null;
    }

    public final void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.module = null;
        this.loadingState = state;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.logicalState = LogicalState.STATE_UNCHECKED;
        this.exception = e;
    }

    public final LoadingState getLoadingState() {
        return this.loadingState;
    }

    public final boolean isLoaded() {
        return this.loadingState == LoadingState.STATE_LOADED;
    }

    public final void setLoaded(QedeqBo module) {
        this.loadingState = LoadingState.STATE_LOADED;
        this.module = module;
    }

    public final QedeqBo getModule() {
        if (this.loadingState != LoadingState.STATE_LOADED) {
            throw new IllegalStateException("module exists only if state is \"" + LoadingState.STATE_LOADED.getText() + "\"");
        }
        return this.module;
    }

    public final void setDependencyProgressState(DependencyState state) {
        if (!this.isLoaded() && state != DependencyState.STATE_UNDEFINED) {
            throw new IllegalArgumentException("module is not yet loaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setDependencyFailureState");
        }
        if (state == DependencyState.STATE_LOADED_REQUIRED_MODULES) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoadedRequiredModules");
        }
        if (state != DependencyState.STATE_LOADED_REQUIRED_MODULES) {
            this.logicalState = LogicalState.STATE_UNCHECKED;
        }
        this.exception = null;
        this.dependencyState = state;
    }

    public final void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        if (!this.isLoaded()) {
            throw new IllegalArgumentException("module is not yet loaded");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.logicalState = LogicalState.STATE_UNCHECKED;
        this.dependencyState = state;
        this.exception = e;
    }

    public final DependencyState getDependencyState() {
        return this.dependencyState;
    }

    public final void setLoadedRequiredModules(ModuleReferenceList list) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Required modules can only be set if module is loaded.\"\nCurrently the status for the module\"" + this.getName() + "\" is \"" + this.getLoadingState() + "\"");
        }
        this.dependencyState = DependencyState.STATE_LOADED_REQUIRED_MODULES;
        this.required = list;
    }

    public final ModuleReferenceList getRequiredModules() {
        if (!this.hasLoadedRequiredModules()) {
            throw new IllegalStateException("module reference list exists only if state is \"" + DependencyState.STATE_LOADED_REQUIRED_MODULES.getText() + "\"");
        }
        return this.required;
    }

    public final boolean hasLoadedRequiredModules() {
        return this.loadingState == LoadingState.STATE_LOADED && this.dependencyState == DependencyState.STATE_LOADED_REQUIRED_MODULES;
    }

    public final void setLogicalProgressState(LogicalState state) {
        if (this.dependencyState.getCode() < DependencyState.STATE_LOADED_REQUIRED_MODULES.getCode() && state != LogicalState.STATE_UNCHECKED) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLogicalFailureState");
        }
        this.exception = null;
        this.logicalState = state;
    }

    public final void setLogicalFailureState(LogicalState state, SourceFileExceptionList e) {
        if (!(this.isLoaded() && this.hasLoadedRequiredModules() || state == LogicalState.STATE_UNCHECKED)) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLogicalProgressState");
        }
        this.logicalState = state;
        this.exception = e;
    }

    public final LogicalState getLogicalState() {
        return this.logicalState;
    }

    public final SourceFileExceptionList getException() {
        return this.exception;
    }

    public final String getStateDescription() {
        if (this.loadingState == LoadingState.STATE_LOADING_FROM_WEB) {
            return this.loadingState.getText() + " (" + this.loadingCompleteness + "%)";
        }
        if (!this.isLoaded()) {
            return this.loadingState.getText();
        }
        if (!this.hasLoadedRequiredModules()) {
            return this.dependencyState.getText();
        }
        return this.logicalState.getText();
    }

    public final String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public final String getRuleVersion() {
        if (this.address == null || this.module == null || this.module.getQedeq() == null || this.module.getQedeq().getHeader() == null || this.module.getQedeq().getHeader().getSpecification() == null || this.module.getQedeq().getHeader().getSpecification().getRuleVersion() == null) {
            return "";
        }
        return this.module.getQedeq().getHeader().getSpecification().getRuleVersion();
    }

    public final URL getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getURL();
    }

    public final String toString() {
        return super.toString() + ":" + this.address + ";" + this.loadingState;
    }
}

