/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;

public class DefaultModuleAddress
implements ModuleAddress {
    private final String address;
    private final URL url;
    private final String header;
    private final String path;
    private final String fileName;
    private final boolean relativeAddress;
    private final String name;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$load$DefaultModuleAddress;

    public DefaultModuleAddress(URL u, DefaultModuleAddress parent) throws IOException {
        this(u.toExternalForm(), parent);
    }

    public DefaultModuleAddress(URL u) throws IOException {
        this(u.toExternalForm(), (DefaultModuleAddress)null);
    }

    public DefaultModuleAddress(File file) throws IOException {
        this(IoUtility.toUrl(file), (DefaultModuleAddress)null);
    }

    public DefaultModuleAddress(String address) throws IOException {
        this(address, (DefaultModuleAddress)null);
    }

    public DefaultModuleAddress(String address, DefaultModuleAddress parent) throws IOException {
        String mname;
        URL urmel;
        String method = "ModuleAddress(String, ModuleAddress)";
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            urmel = parent != null ? new URL(parent.url, address) : new URL(address);
        }
        catch (MalformedURLException e) {
            Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("address=" + address));
            Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("parent=" + parent));
            Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Throwable)e);
            try {
                String newAddress = "file:" + address;
                urmel = parent != null ? new URL(parent.url, newAddress) : new URL(newAddress);
            }
            catch (MalformedURLException ex) {
                throw e;
            }
        }
        Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("protocol=" + urmel.getProtocol()));
        this.url = urmel;
        this.address = urmel.toExternalForm();
        Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("address=" + this.address));
        String p = urmel.getFile();
        int position = p.lastIndexOf("/");
        if (position >= 0 && position + 1 < p.length()) {
            this.path = p.substring(0, position) + "/";
            this.fileName = p.substring(position + 1);
        } else {
            this.path = "";
            this.fileName = p;
        }
        Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("path=" + this.path));
        Trace.trace((Object)this, "ModuleAddress(String, ModuleAddress)", (Object)("fileName=" + this.fileName));
        boolean bl = this.relativeAddress = !this.path.startsWith("/");
        if (!this.fileName.endsWith(".xml")) {
            throw new IOException("file name doesn't end with \".xml\": " + this.fileName);
        }
        int positionBefore = this.fileName.lastIndexOf(".");
        this.name = mname = this.fileName.substring(0, positionBefore);
        int positionPath = this.address.lastIndexOf(this.path + this.fileName);
        if (positionPath < 0) {
            throw new IllegalArgumentException("couldn't determine begin of file path: " + this.address);
        }
        this.header = this.address.substring(0, positionPath);
    }

    public final String getAddress() {
        return this.address;
    }

    public final ModuleContext createModuleContext() {
        return new ModuleContext(this.getURL());
    }

    public final String getHeader() {
        return this.header;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getName() {
        return this.name;
    }

    public final URL getURL() {
        return this.url;
    }

    public final boolean isRelativeAddress() {
        return this.relativeAddress;
    }

    public final boolean isFileAddress() {
        return this.getAddress().indexOf("file:") == 0;
    }

    public final String localizeInFileSystem(URL url) {
        String method = "localizeInFileSystem(URL)";
        Trace.traceStack(this, "localizeInFileSystem(URL)");
        Trace.param((Object)this, "localizeInFileSystem(URL)", "protocoll", (Object)url.getProtocol());
        Trace.param((Object)this, "localizeInFileSystem(URL)", "host", (Object)url.getHost());
        Trace.param((Object)this, "localizeInFileSystem(URL)", "port", url.getPort());
        Trace.param((Object)this, "localizeInFileSystem(URL)", "path", (Object)url.getPath());
        Trace.param((Object)this, "localizeInFileSystem(URL)", "file", (Object)url.getFile());
        StringBuffer file = new StringBuffer(url.getFile());
        ReplaceUtility.replace(file, "_", "__");
        ReplaceUtility.replace(file, "/", "_1");
        String encoded = file.toString();
        try {
            encoded = URLEncoder.encode(file.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(class$org$qedeq$kernel$bo$load$DefaultModuleAddress == null ? (class$org$qedeq$kernel$bo$load$DefaultModuleAddress = DefaultModuleAddress.class$("org.qedeq.kernel.bo.load.DefaultModuleAddress")) : class$org$qedeq$kernel$bo$load$DefaultModuleAddress, "localizeInFileSystem(String)", (Throwable)e);
        }
        file.setLength(0);
        file.append(encoded);
        ReplaceUtility.replace(file, "#", "##");
        ReplaceUtility.replace(file, "_1", "#");
        ReplaceUtility.replace(file, "__", "_");
        StringBuffer adr = new StringBuffer(url.toExternalForm());
        try {
            adr = new StringBuffer(new URL(url.getProtocol(), url.getHost(), url.getPort(), file.toString()).toExternalForm());
        }
        catch (MalformedURLException e) {
            Trace.fatal(this, "localizeInFileSystem(URL)", "unexpected", (Throwable)e);
            e.printStackTrace();
        }
        ReplaceUtility.replace(adr, "://", "_");
        ReplaceUtility.replace(adr, ":", "_");
        return adr.toString();
    }

    public final String createRelativeAddress(ModuleAddress reference) {
        return DefaultModuleAddress.createRelativeAddress(this.getAddress(), reference.getAddress());
    }

    public final String toString() {
        return this.address;
    }

    public final int hashCode() {
        return this.address.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultModuleAddress)) {
            return false;
        }
        return this.address.equals(((DefaultModuleAddress)object).address);
    }

    public static final String getModuleFileName(Specification spec) {
        return spec.getName() + ".xml";
    }

    public static final ModuleAddress[] getModulePaths(QedeqBo module, Specification spec) throws IOException {
        String fileNameEnd = DefaultModuleAddress.getModuleFileName(spec);
        LocationList locations = spec.getLocationList();
        ModuleAddress[] result = new ModuleAddress[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            String fileName = locations.get(i).getLocation();
            if (fileName.equals(".")) {
                fileName = "";
            } else if (!fileName.endsWith("/")) {
                fileName = fileName + "/";
            }
            fileName = fileName + fileNameEnd;
            result[i] = new DefaultModuleAddress(fileName, (DefaultModuleAddress)module.getModuleAddress());
        }
        return result;
    }

    public static final String createRelativeAddress(String origin, String next) {
        if (origin.equals(next)) {
            return "";
        }
        try {
            URL urlOrgin = new URL(origin);
            URL urlNext = new URL(next);
            if (urlOrgin.getProtocol().equals(urlNext.getProtocol()) && urlOrgin.getHost().equals(urlNext.getHost()) && urlOrgin.getPort() == urlNext.getPort()) {
                String org = urlOrgin.getFile();
                String nex = urlNext.getFile();
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j));
                    return result.toString();
                }
                return "/" + nex;
            }
            return urlNext.toString();
        }
        catch (MalformedURLException e) {
            return next;
        }
    }

    public static final String newEnding(String address, String newEnding) {
        if (address.length() == 0) {
            return "";
        }
        int i = address.lastIndexOf(".");
        if (i > 0) {
            return address.substring(0, i + 1) + newEnding;
        }
        return address + "." + newEnding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

