/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.bo.logic.ExistenceChecker;
import org.qedeq.kernel.bo.logic.FormulaChecker;
import org.qedeq.kernel.bo.module.IllegalModuleDataException;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTransverser;
import org.qedeq.kernel.dto.module.PredicateDefinitionVo;

public final class QedeqBoFormalLogicChecker
extends AbstractModuleVisitor
implements ExistenceChecker {
    private final QedeqBo original;
    private final QedeqNotNullTransverser transverser;
    private final Map predicateDefinitions = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private boolean setDefinitionByFormula;

    private QedeqBoFormalLogicChecker(URL globalContext, QedeqBo qedeq) {
        this.transverser = new QedeqNotNullTransverser(globalContext, this);
        this.original = qedeq;
    }

    public static void check(URL globalContext, QedeqBo qedeq) throws ModuleDataException {
        QedeqBoFormalLogicChecker checker = new QedeqBoFormalLogicChecker(globalContext, qedeq);
        checker.check();
    }

    private void check() throws ModuleDataException {
        this.predicateDefinitions.clear();
        this.functionDefinitions.clear();
        this.setDefinitionByFormula = false;
        PredicateDefinitionVo equal = new PredicateDefinitionVo();
        equal.setArgumentNumber("2");
        equal.setName("equal");
        equal.setLatexPattern("#1 \\ =  \\ #2");
        this.predicateDefinitions.put(equal.getName() + "_" + equal.getArgumentNumber(), equal);
        PredicateDefinitionVo notEqual = new PredicateDefinitionVo();
        notEqual.setArgumentNumber("2");
        notEqual.setName("notEqual");
        notEqual.setLatexPattern("#1 \\ \\neq  \\ #2");
        this.predicateDefinitions.put(notEqual.getName() + "_" + notEqual.getArgumentNumber(), notEqual);
        this.transverser.accept(this.original.getQedeq());
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this);
        }
        this.setLocationWithinModule(context);
        this.transverser.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.transverser.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        String key = definition.getName() + "_" + definition.getArgumentNumber();
        if (this.predicateDefinitions.get(key) != null) {
            throw new IllegalModuleDataException(40400, "predicate was already defined for this argument number", this.getCurrentContext());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = definition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this);
        }
        this.predicateDefinitions.put(key, definition);
        this.setLocationWithinModule(context);
        this.transverser.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.transverser.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        String key = definition.getName() + "_" + definition.getArgumentNumber();
        if (this.functionDefinitions.get(key) != null) {
            throw new IllegalModuleDataException(40400, "function was already defined for this argument number", this.getCurrentContext());
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm().getElement()");
            Term term = definition.getTerm();
            FormulaChecker.checkTerm(term.getElement(), this.getCurrentContext(), this);
        }
        this.predicateDefinitions.put(key, definition);
        this.setLocationWithinModule(context);
        this.transverser.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.transverser.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this);
        }
        this.setLocationWithinModule(context);
        this.transverser.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.transverser.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (rule.getName() != null && "SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
            this.setDefinitionByFormula = true;
        }
        this.transverser.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.transverser.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public final ModuleContext getCurrentContext() {
        return this.transverser.getCurrentContext();
    }

    protected final Qedeq getQedeqOriginal() {
        return this.original.getQedeq();
    }

    public boolean predicateExists(String name, int arguments) {
        PredicateDefinition definition = (PredicateDefinition)this.predicateDefinitions.get(name + "_" + arguments);
        return null != definition;
    }

    public boolean functionExists(String name, int arguments) {
        FunctionDefinition definition = (FunctionDefinition)this.predicateDefinitions.get(name + "_" + arguments);
        return null != definition;
    }

    public boolean classOperatorExists() {
        return this.setDefinitionByFormula;
    }

    public boolean equalityOperatorExists() {
        return true;
    }

    public String getEqualityOperator() {
        return "equal";
    }
}

