/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.net.URL;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.bo.control.LoadRequiredModuleException;
import org.qedeq.kernel.bo.module.DependencyState;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.ModuleReferenceList;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTransverser;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultSourceFileExceptionList;

public final class LoadRequiredModules
extends AbstractModuleVisitor {
    private final QedeqNotNullTransverser transverser;
    private final QedeqBo qedeq;
    private final ModuleReferenceList required;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$LoadRequiredModules;

    private LoadRequiredModules(QedeqBo qedeq) {
        this.qedeq = qedeq;
        this.transverser = new QedeqNotNullTransverser(qedeq.getModuleAddress().getURL(), this);
        this.required = new ModuleReferenceList();
    }

    public static void loadRequired(URL qedeqUrl) throws ModuleDataException, SourceFileExceptionList {
        String method = "loadRequired(QedeqBo)";
        ModuleProperties prop = KernelContext.getInstance().getModuleProperties(qedeqUrl);
        if (prop.getDependencyState().areAllRequiredLoaded()) {
            return;
        }
        QedeqBo bo = KernelContext.getInstance().loadModule(qedeqUrl);
        prop.setDependencyProgressState(DependencyState.STATE_LOADING_REQUIRED_MODULES);
        LoadRequiredModules converter = new LoadRequiredModules(bo);
        try {
            converter.loadRequired();
            prop.setLoadedRequiredModules(converter.required);
        }
        catch (ModuleDataException e) {
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, ModuleDataException2XmlFileException.createXmlFileExceptionList(e, bo.getQedeq()));
            throw e;
        }
        catch (RuntimeException e) {
            Trace.fatal(class$org$qedeq$kernel$bo$control$LoadRequiredModules == null ? (class$org$qedeq$kernel$bo$control$LoadRequiredModules = LoadRequiredModules.class$("org.qedeq.kernel.bo.control.LoadRequiredModules")) : class$org$qedeq$kernel$bo$control$LoadRequiredModules, "loadRequired(QedeqBo)", "programming error", (Throwable)e);
            LoadRequiredModuleException me = new LoadRequiredModuleException(10, e.toString(), converter.transverser.getCurrentContext());
            DefaultSourceFileExceptionList xl = new DefaultSourceFileExceptionList(e);
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, xl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw me;
        }
        catch (Throwable e) {
            LoadRequiredModuleException me = new LoadRequiredModuleException(10, e.toString(), converter.transverser.getCurrentContext());
            DefaultSourceFileExceptionList xl = new DefaultSourceFileExceptionList(e);
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, xl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw me;
        }
    }

    private final void loadRequired() throws ModuleDataException {
        this.transverser.accept(this.qedeq.getQedeq());
    }

    public void visitEnter(Import imp) throws ModuleDataException {
        try {
            QedeqBo other = KernelContext.getInstance().loadModule(this.qedeq, imp.getSpecification());
            this.required.add(this.transverser.getCurrentContext(), imp.getLabel(), other.getModuleAddress().getURL());
            LoadRequiredModules.loadRequired(other.getModuleAddress().getURL());
        }
        catch (SourceFileExceptionList e) {
            Trace.trace((Object)this, "visitEnter(Import)", (Throwable)e);
            throw new LoadRequiredModuleException(e.get(0).getErrorCode(), "import of module labeled \"" + imp.getLabel() + "\" failed: " + e.get(0).getMessage(), this.transverser.getCurrentContext());
        }
    }

    public void visitLeave(ImportList imports) {
        this.transverser.setBlocked(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

