/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.kernel.common.SyntaxExceptionList;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.parser.DefaultXmlFileExceptionList;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxEntityResolver;
import org.qedeq.kernel.xml.parser.SaxErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxParser {
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private SaxDefaultHandler handler;
    private XMLReader reader;
    private final DefaultHandler deflt;
    private SyntaxExceptionList exceptionList;

    public SaxParser(SaxDefaultHandler handler) throws ParserConfigurationException, SAXException {
        this.handler = handler;
        this.deflt = new DefaultHandler();
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setFeature(NAMESPACES_FEATURE_ID, true);
        factory.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            factory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace((Object)this, "constructor", (Throwable)e);
        }
        try {
            factory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace((Object)this, "constructor", (Throwable)e);
        }
        SAXParser parser = factory.newSAXParser();
        if (!parser.isNamespaceAware()) {
            throw new ParserConfigurationException("Current XML parser doesn't support namespaces.");
        }
        if (!parser.isValidating()) {
            throw new ParserConfigurationException("Current XML parser doesn't support schema validation.");
        }
        this.reader = parser.getXMLReader();
        this.reader.setEntityResolver(new SaxEntityResolver(handler));
        this.reader.setFeature(NAMESPACES_FEATURE_ID, true);
        this.reader.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            this.reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace((Object)this, "constructor", (Throwable)e);
        }
        try {
            this.reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace((Object)this, "constructor", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(URL url, boolean validateOnly) throws XmlFileExceptionList {
        String method = "parse(URL, boolean)";
        Trace.param((Object)this, "parse(URL, boolean)", "url", (Object)url);
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            throw new DefaultXmlFileExceptionList(e);
        }
        try {
            this.parse(url, validateOnly, in);
            Object var7_6 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                Trace.trace((Object)this, "parse(URL, boolean)", (Throwable)e);
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (Exception e) {
            Trace.trace((Object)this, "parse(URL, boolean)", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parse(URL url, boolean validateOnly, InputStream in) throws XmlFileExceptionList {
        block14: {
            method = "parse(URL, boolean, InputStream)";
            dis = null;
            try {
                block13: {
                    dis = new BufferedReader(new InputStreamReader(in));
                    input = new InputSource(dis);
                    this.exceptionList = new SyntaxExceptionList();
                    this.reader.setErrorHandler(new SaxErrorHandler(url, this.exceptionList));
                    if (validateOnly) {
                        this.reader.setContentHandler(this.deflt);
                        this.reader.parse(input);
                        break block13;
                    }
                    this.handler.setExceptionList(this.exceptionList);
                    this.reader.setContentHandler(this.handler);
                    this.handler.setUrl(url);
                    this.reader.parse(input);
                }
                var9_9 = null;
                ** if (dis == null) goto lbl-1000
            }
            catch (Throwable var8_15) {
                var9_10 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Exception e) {
                        Trace.trace((Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                    }
                }
                throw var8_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dis.close();
                }
                catch (Exception e) {
                    Trace.trace((Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (SAXException e) {
                    e.printStackTrace();
                    list = new DefaultXmlFileExceptionList(this.exceptionList);
                    if (this.exceptionList.size() <= 0) {
                        list.add(e);
                    }
                    throw list;
                }
                catch (IOException e) {
                    list = new DefaultXmlFileExceptionList(this.exceptionList);
                    list.add(e);
                    throw list;
                }
            }
        }
        if (this.exceptionList.size() > 0) {
            throw new DefaultXmlFileExceptionList(this.exceptionList);
        }
    }

    public final void parse(String fileName) throws XmlFileExceptionList {
        File file = new File(fileName);
        this.parse(file.getAbsoluteFile());
    }

    public final void parse(File file) throws XmlFileExceptionList {
        URL url;
        try {
            url = file.getAbsoluteFile().toURI().toURL();
        }
        catch (IOException e) {
            DefaultXmlFileExceptionList list = new DefaultXmlFileExceptionList();
            list.add(e);
            throw list;
        }
        this.parse(url, true);
        this.parse(url, false);
    }

    public final void parse(URL url) throws XmlFileExceptionList {
        this.parse(url, true);
        this.parse(url, false);
    }

    public void parse(InputStream in, boolean validateOnly) throws XmlFileExceptionList {
        this.parse(null, validateOnly, in);
    }

    public SyntaxExceptionList getExceptionList() {
        return this.exceptionList;
    }
}

