/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.handler.module;

import org.qedeq.kernel.common.SyntaxException;
import org.qedeq.kernel.dto.module.ChapterVo;
import org.qedeq.kernel.xml.handler.module.LatexListHandler;
import org.qedeq.kernel.xml.handler.module.SectionHandler;
import org.qedeq.kernel.xml.parser.AbstractSimpleHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;

public class ChapterHandler
extends AbstractSimpleHandler {
    private final LatexListHandler titleHandler = new LatexListHandler(this, "TITLE");
    private final LatexListHandler introductionHandler = new LatexListHandler(this, "INTRODUCTION");
    private final SectionHandler sectionHandler = new SectionHandler(this);
    private ChapterVo chapter;

    public ChapterHandler(AbstractSimpleHandler handler) {
        super(handler, "CHAPTER");
    }

    public void init() {
        this.chapter = null;
    }

    public final ChapterVo getChapter() {
        return this.chapter;
    }

    public final void startElement(String name, SimpleAttributes attributes) throws SyntaxException {
        if (this.getStartTag().equals(name)) {
            this.chapter = new ChapterVo();
            this.chapter.setNoNumber(attributes.getBoolean("noNumber"));
        } else if (this.titleHandler.getStartTag().equals(name)) {
            this.changeHandler(this.titleHandler, name, attributes);
        } else if (this.introductionHandler.getStartTag().equals(name)) {
            this.changeHandler(this.introductionHandler, name, attributes);
        } else if (this.sectionHandler.getStartTag().equals(name)) {
            this.changeHandler(this.sectionHandler, name, attributes);
        } else {
            throw SyntaxException.createUnexpectedTagException(name);
        }
    }

    public final void endElement(String name) throws SyntaxException {
        if (!this.getStartTag().equals(name)) {
            if (this.titleHandler.getStartTag().equals(name)) {
                this.chapter.setTitle(this.titleHandler.getLatexList());
            } else if (this.introductionHandler.getStartTag().equals(name)) {
                this.chapter.setIntroduction(this.introductionHandler.getLatexList());
            } else if (this.sectionHandler.getStartTag().equals(name)) {
                this.chapter.addSection(this.sectionHandler.getSection());
            } else {
                throw SyntaxException.createUnexpectedTagException(name);
            }
        }
    }
}

