/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.context;

import java.io.File;
import java.io.IOException;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.bo.module.Kernel;
import org.qedeq.kernel.bo.module.KernelState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleFactory;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.config.QedeqConfig;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;

public final class KernelContext
implements Kernel {
    private static final String KERNEL_VERSION = "0.03.05";
    private static final String KERNEL_VERSION_DIRECTORY = "0.03.05".replace('.', '_');
    private static final String DESCRIPTIVE_KERNEL_VERSION = "Hilbert II - Version 0.03.05 (mongaga)";
    private static final String MAXIMAL_RULE_VERSION = "1.00.00";
    private static final KernelContext INSTANCE = new KernelContext();
    private final KernelState initialState = new KernelState(){

        public void init(ModuleFactory moduleFactory) throws IOException {
            QedeqLog.getInstance().logMessage("This is " + KernelContext.getInstance().getDescriptiveKernelVersion());
            QedeqLog.getInstance().logMessage("  see \"http://www.qedeq.org\" for more information");
            QedeqLog.getInstance().logMessage("  supports rules till version " + KernelContext.getInstance().getMaximalRuleVersion());
            KernelContext.this.config = new QedeqConfig(new File(IoUtility.getStartDirectory("qedeq"), "config"), "org.qedeq.properties", "This file is part of the project *Hilbert II* - http://www.qedeq.org");
            QedeqLog.getInstance().logMessage("QEDEQ kernel opened.");
            KernelContext.this.moduleFactory = moduleFactory;
            KernelContext.this.currentState = KernelContext.this.initializedState;
        }

        public boolean isReady() {
            return false;
        }

        public QedeqConfig getConfig() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void shutdown() {
        }

        public void startup() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo loadModule(String address) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo loadModule(ModuleAddress moduleAddress) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo loadModule(QedeqBo module, Specification spec) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not initialized");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String getBufferDirectory() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String getGenerationDirectory() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleProperties getModuleProperties(String address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String getLocalName(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }
    };
    private final KernelState initializedState = new KernelState(){

        public void init(ModuleFactory moduleFactory) throws IOException {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public boolean isReady() {
            return false;
        }

        public QedeqConfig getConfig() {
            return KernelContext.this.config;
        }

        public void shutdown() {
            KernelContext.this.config = null;
            KernelContext.this.currentState = KernelContext.this.initialState;
            KernelContext.this.moduleFactory = null;
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
        }

        public void startup() {
            KernelContext.this.moduleFactory.startup();
            KernelContext.this.currentState = KernelContext.this.readyState;
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo loadModule(String address) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo loadModule(ModuleAddress moduleAddress) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo loadModule(QedeqBo module, Specification spec) throws XmlFileExceptionList {
            throw new IllegalStateException("Kernel not started");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not started");
        }

        public String[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public String getBufferDirectory() {
            throw new IllegalStateException("Kernel not started");
        }

        public String getGenerationDirectory() {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleProperties getModuleProperties(String address) {
            throw new IllegalStateException("Kernel not started");
        }

        public String getLocalName(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }
    };
    private final KernelState readyState = new KernelState(){

        public void init(ModuleFactory moduleFactory) throws IOException {
        }

        public boolean isReady() {
            return false;
        }

        public QedeqConfig getConfig() {
            return KernelContext.this.config;
        }

        public void shutdown() {
            try {
                KernelContext.this.config.setLoadedModules(KernelContext.this.moduleFactory.getAllLoadedModules());
                KernelContext.this.config.store();
                KernelContext.this.config = null;
                QedeqLog.getInstance().logMessage("Current config file successfully saved.");
            }
            catch (IOException e) {
                Trace.trace((Object)this, "shutdown()", (Throwable)e);
                QedeqLog.getInstance().logMessage("Saving current config file failed.");
            }
            KernelContext.this.currentState = KernelContext.this.initialState;
            KernelContext.this.moduleFactory = null;
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
        }

        public void startup() {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public void removeAllModules() {
            KernelContext.this.moduleFactory.removeAllModules();
        }

        public void clearLocalBuffer() throws IOException {
            KernelContext.this.moduleFactory.clearLocalBuffer();
        }

        public QedeqBo loadModule(String address) throws XmlFileExceptionList {
            return KernelContext.this.moduleFactory.loadModule(address);
        }

        public QedeqBo loadModule(ModuleAddress moduleAddress) throws XmlFileExceptionList {
            return KernelContext.this.moduleFactory.loadModule(moduleAddress);
        }

        public QedeqBo loadModule(QedeqBo module, Specification spec) throws XmlFileExceptionList {
            return KernelContext.this.moduleFactory.loadModule(module, spec);
        }

        public boolean loadAllModulesFromQedeq() {
            return KernelContext.this.moduleFactory.loadAllModulesFromQedeq();
        }

        public String[] getAllLoadedModules() {
            return KernelContext.this.moduleFactory.getAllLoadedModules();
        }

        public String getBufferDirectory() {
            return KernelContext.this.moduleFactory.getBufferDirectory();
        }

        public String getGenerationDirectory() {
            return KernelContext.this.moduleFactory.getGenerationDirectory();
        }

        public ModuleProperties getModuleProperties(String address) {
            return KernelContext.this.moduleFactory.getModuleProperties(address);
        }

        public String getLocalName(ModuleAddress address) {
            return KernelContext.this.moduleFactory.getLocalName(address);
        }
    };
    private KernelState currentState = this.initialState;
    private QedeqConfig config;
    private ModuleFactory moduleFactory;

    private KernelContext() {
    }

    public static final KernelContext getInstance() {
        return INSTANCE;
    }

    public final String getKernelVersion() {
        return KERNEL_VERSION;
    }

    public final String getKernelVersionDirectory() {
        return KERNEL_VERSION_DIRECTORY;
    }

    public final String getDescriptiveKernelVersion() {
        return DESCRIPTIVE_KERNEL_VERSION;
    }

    public final String getMaximalRuleVersion() {
        return MAXIMAL_RULE_VERSION;
    }

    public final boolean isRuleVersionSupported(String ruleVersion) {
        return MAXIMAL_RULE_VERSION.equals(ruleVersion);
    }

    public void init(ModuleFactory moduleFactory) throws IOException {
        this.currentState.init(moduleFactory);
    }

    public boolean isReady() {
        return this.currentState.isReady();
    }

    public QedeqConfig getConfig() {
        return this.currentState.getConfig();
    }

    public void shutdown() {
        this.currentState.shutdown();
    }

    public void startup() {
        this.currentState.startup();
    }

    public void removeAllModules() {
        this.currentState.removeAllModules();
    }

    public void clearLocalBuffer() throws IOException {
        this.currentState.clearLocalBuffer();
    }

    public QedeqBo loadModule(String address) throws XmlFileExceptionList {
        return this.currentState.loadModule(address);
    }

    public QedeqBo loadModule(ModuleAddress moduleAddress) throws XmlFileExceptionList {
        return this.currentState.loadModule(moduleAddress);
    }

    public QedeqBo loadModule(QedeqBo module, Specification spec) throws XmlFileExceptionList {
        return this.currentState.loadModule(module, spec);
    }

    public boolean loadAllModulesFromQedeq() {
        return this.currentState.loadAllModulesFromQedeq();
    }

    public String[] getAllLoadedModules() {
        return this.currentState.getAllLoadedModules();
    }

    public String getBufferDirectory() {
        return this.currentState.getBufferDirectory();
    }

    public String getGenerationDirectory() {
        return this.currentState.getGenerationDirectory();
    }

    public ModuleProperties getModuleProperties(String address) {
        return this.currentState.getModuleProperties(address);
    }

    public String getLocalName(ModuleAddress address) {
        return this.currentState.getLocalName(address);
    }
}

