/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.qedeq.kernel.config.ConfigAccess;

public final class QedeqConfig {
    private static final String DEFAULT_LOCAL_MODULES_DIRECTORY = "local";
    private static final String DEFAULT_LOCAL_BUFFER = "buffer";
    private static final String DEFAULT_GENERATED = "generated";
    private static final String DEFAULT_LOG_FILE = "log/log.txt";
    private final ConfigAccess configAccess;

    public QedeqConfig(File configDirectory, String configFileName, String description) throws IOException {
        this.configAccess = new ConfigAccess(configDirectory, configFileName, description);
    }

    public final void store() throws IOException {
        this.configAccess.store();
    }

    public final String getGenerationDirectory() {
        String location = this.configAccess.getString("generationLocation");
        if (location == null) {
            return DEFAULT_GENERATED;
        }
        return location;
    }

    public final void setGenerationDirectory(String location) {
        this.configAccess.setString("generationLocation", location);
    }

    public final String getBufferDirectory() {
        String location = this.configAccess.getString("bufferLocation");
        if (location == null) {
            return DEFAULT_LOCAL_BUFFER;
        }
        return location;
    }

    public final void setBufferDirectory(String location) {
        this.configAccess.setString("bufferLocation", location);
    }

    public final String getLogFilePath() {
        String location = this.configAccess.getString("logLocation");
        if (location == null) {
            return DEFAULT_LOG_FILE;
        }
        return location;
    }

    public final String[] getModuleHistory() {
        return this.configAccess.getStringProperties("moduleHistory.");
    }

    public final void saveModuleHistory(List modules) {
        this.configAccess.removeProperties("moduleHistory.");
        for (int i = 0; i < modules.size(); ++i) {
            this.configAccess.setString("moduleHistory." + (i + 101), modules.get(i).toString());
        }
    }

    public final String[] getPreviouslyCheckedModules() {
        return this.configAccess.getStringProperties("checkedModule.");
    }

    public final void setLoadedModules(String[] moduleAddresses) {
        this.configAccess.removeProperties("checkedModule.");
        for (int i = 0; i < moduleAddresses.length; ++i) {
            this.configAccess.setString("checkedModule." + (i + 1), moduleAddresses[i]);
        }
    }

    public final File getStartDirectory() {
        return new File(".");
    }

    public final boolean isAutoStartHtmlBrowser() {
        return "true".equals(this.configAccess.getString("autoStartHtmlBrowser", "true"));
    }

    public final void setAutoStartHtmlBrowser(boolean mode) {
        this.configAccess.setString("autoStartHtmlBrowser", mode ? "true" : "false");
    }

    public final boolean isDirectResponse() {
        return "true".equals(this.configAccess.getString("directResponse", "true"));
    }

    public final void setDirectResponse(boolean mode) {
        this.configAccess.setString("directResponse", mode ? "true" : "false");
    }

    public boolean isAutoReloadLastSessionChecked() {
        return "true".equals(this.configAccess.getString("sessionAutoReload", "true"));
    }

    public final void setAutoReloadLastSessionChecked(boolean mode) {
        this.configAccess.setString("sessionAutoReload", mode ? "true" : "false");
    }

    public final boolean isOldHtml() {
        return "true".equals(this.configAccess.getString("oldHtml", "true"));
    }

    public final void setOldHtml(boolean mode) {
        this.configAccess.setString("oldHtml", mode ? "true" : "false");
    }

    public final String getLocalModulesDirectory() {
        String location = this.configAccess.getString("localModulesDirectory");
        if (location == null) {
            return DEFAULT_LOCAL_MODULES_DIRECTORY;
        }
        return location;
    }

    public final void setLocalModulesDirectory(String location) {
        this.configAccess.setString("localModulesDirectory", location);
    }
}

