/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.common.SyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SyntaxExceptionList {
    private List exceptions = new ArrayList(10);
    public static final int MAXIMUM = 10;

    public final void add(SyntaxException e) throws SAXException {
        if (e == null) {
            NullPointerException ex = new NullPointerException("Exception expected!");
            this.exceptions.add(ex);
            throw ex;
        }
        if (this.size() >= 10) {
            throw new SAXException("Too much errors already occurred.");
        }
        this.exceptions.add(e);
    }

    public final int size() {
        return this.exceptions.size();
    }

    public final SyntaxException get(int i) {
        return (SyntaxException)this.exceptions.get(i);
    }

    public final SyntaxException[] toArray() {
        return this.exceptions.toArray(new SyntaxException[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            SyntaxException e;
            if (i != 0) {
                buffer.append("\n");
            }
            if ((e = this.get(i)) instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)((Object)e);
                buffer.append(ex.getSystemId() != null ? ex.getPublicId() + " " : "");
                buffer.append(ex.getSystemId() != null ? ex.getSystemId() + " " : "");
                buffer.append(ex.getLineNumber() != -1 ? "Row: " + ex.getLineNumber() + ". " : "");
                buffer.append(ex.getColumnNumber() != -1 ? "Column: " + ex.getColumnNumber() + ". " : "");
                buffer.append(ex.getException() != null ? ex.getException().getMessage() : ex.getMessage());
                continue;
            }
            buffer.append(this.get(i));
        }
        return buffer.toString();
    }
}

