/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.net.URL;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.LogicalState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.QedeqBo;

public class DefaultModuleProperties
implements ModuleProperties {
    private final ModuleAddress address;
    private int loadingCompleteness;
    private LoadingState loadingState;
    private LogicalState logicalState;
    private QedeqBo module;
    private Exception exception;

    public DefaultModuleProperties(ModuleAddress address) {
        this.address = address;
        this.loadingState = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
        this.logicalState = LogicalState.STATE_UNCHECKED;
    }

    public final boolean hasFailures() {
        return this.loadingState.isFailure();
    }

    public final String getAddress() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getAddress();
    }

    public final ModuleAddress getModuleAddress() {
        return this.address;
    }

    public final void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public final void setLoadingProgressState(LoadingState state) {
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setCheckedAndLoaded");
        }
        if (this.loadingState == LoadingState.STATE_LOADED) {
            this.module = null;
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState");
        }
        this.exception = null;
        this.loadingState = state;
    }

    public final void setLoadingFailureState(LoadingState state, Exception e) {
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setProgressState");
        }
        if (this.loadingState == LoadingState.STATE_LOADED) {
            this.module = null;
        }
        this.loadingState = state;
        this.exception = e;
    }

    public final LoadingState getLoadingState() {
        return this.loadingState;
    }

    public final void setLogicalProgressState(LogicalState state) {
        if (state != LogicalState.STATE_UNCHECKED && this.loadingState != LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set for loaded modules");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLogicalFailureState");
        }
        this.exception = null;
        this.logicalState = state;
    }

    public final void setLogicalFailureState(LogicalState state, Exception e) {
        if (state != LogicalState.STATE_UNCHECKED && this.loadingState != LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set for loaded modules");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setProgressState");
        }
        this.logicalState = state;
        this.exception = e;
    }

    public final LogicalState getLogicalState() {
        return this.logicalState;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final String getStateDescription() {
        if (this.loadingState == LoadingState.STATE_LOADING_FROM_WEB) {
            return this.loadingState.getText() + " (" + this.loadingCompleteness + "%)";
        }
        return this.loadingState.getText();
    }

    public final String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public final String getRuleVersion() {
        if (this.address == null || this.module == null || this.module.getHeader() == null || this.module.getHeader().getSpecification() == null || this.module.getHeader().getSpecification().getRuleVersion() == null) {
            return "";
        }
        return this.module.getHeader().getSpecification().getRuleVersion();
    }

    public final URL getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getURL();
    }

    public final boolean isLoaded() {
        return this.loadingState == LoadingState.STATE_LOADED;
    }

    public final void setLoaded(QedeqBo module) {
        this.loadingState = LoadingState.STATE_LOADED;
        this.module = module;
    }

    public final QedeqBo getModule() {
        if (this.loadingState != LoadingState.STATE_LOADED) {
            throw new IllegalStateException("module could only be set if state is \"" + LoadingState.STATE_LOADED.getText() + "\"");
        }
        return this.module;
    }

    public final String toString() {
        return super.toString() + ":" + this.address + ";" + this.loadingState;
    }
}

