/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.bo.load.DefaultModuleAddress;
import org.qedeq.kernel.bo.load.DefaultQedeqBo;
import org.qedeq.kernel.bo.load.ModuleFileNotFoundException;
import org.qedeq.kernel.bo.load.Modules;
import org.qedeq.kernel.bo.load.QedeqBoFactory;
import org.qedeq.kernel.bo.module.Kernel;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleFactory;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.xml.handler.module.QedeqHandler;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultXmlFileExceptionList;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.xml.sax.SAXException;

public class DefaultModuleFactory
implements ModuleFactory {
    private final String monitor = new String();
    private final String syncToken = new String();
    private int processCounter = 0;
    private final Modules modules = new Modules();
    private final Kernel kernel;

    public DefaultModuleFactory(Kernel kernel) {
        this.kernel = kernel;
    }

    public final void startup() {
        this.autoReloadLastSessionChecked();
    }

    public final void autoReloadLastSessionChecked() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String method = "start()";
                    try {
                        Trace.begin(this, "start()");
                        QedeqLog.getInstance().logMessage("Trying to load previously successfully loaded modules.");
                        int number = DefaultModuleFactory.this.kernel.getConfig().getPreviouslyCheckedModules().length;
                        if (DefaultModuleFactory.this.loadPreviouslySuccessfullyLoadedModules()) {
                            QedeqLog.getInstance().logMessage("Loading of " + number + " previously successfully loaded module" + (number != 1 ? "s" : "") + " successfully done.");
                        } else {
                            QedeqLog.getInstance().logMessage("Loading of all previously successfully checked modules failed. " + number + " module" + (number != 1 ? "s" : "") + " were loaded.");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace((Object)this, "start()", (Throwable)e);
                    }
                    finally {
                        Trace.begin(this, "start()");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllModules() {
        while (true) {
            String string = this.syncToken;
            synchronized (string) {
                if (this.processCounter == 0) {
                    this.getModules().removeAllModules();
                    return;
                }
            }
            string = this.monitor;
            synchronized (string) {
                try {
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModuleAndDependents(ModuleProperties prop) {
        while (true) {
            String string = this.syncToken;
            synchronized (string) {
                if (this.processCounter == 0) {
                    this.getModules().removeModuleAndDependents(prop);
                    return;
                }
            }
            string = this.monitor;
            synchronized (string) {
                try {
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final void clearLocalBuffer() throws IOException {
        this.removeAllModules();
        File bufferDir = new File(this.getBufferDirectory());
        if (bufferDir.exists() && !IoUtility.deleteDir(bufferDir)) {
            throw new IOException("buffer could not be deleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QedeqBo loadModule(String address) throws XmlFileExceptionList {
        this.processInc();
        try {
            DefaultModuleAddress moduleAddress;
            try {
                moduleAddress = new DefaultModuleAddress(address);
            }
            catch (IOException e) {
                throw this.createXmlFileExceptionList(e);
            }
            QedeqBo qedeqBo = this.loadModule(moduleAddress);
            return qedeqBo;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final QedeqBo loadModule(ModuleAddress moduleAddress) throws XmlFileExceptionList {
        QedeqBo qedeqBo;
        String method = "loadModule(ModuleAddress)";
        this.processInc();
        try {
            ModuleProperties prop;
            ModuleProperties moduleProperties = prop = this.getModules().getModuleProperties(moduleAddress);
            synchronized (moduleProperties) {
                if (prop.isLoaded()) {
                    QedeqBo qedeqBo2 = prop.getModule();
                    // MONITOREXIT @DISABLED, blocks:[0, 7, 14] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.processDec();
                    return qedeqBo2;
                }
            }
        }
        catch (Throwable throwable) {
            this.processDec();
            throw throwable;
        }
        {
            QedeqBo mod;
            try {
                QedeqBo mod2;
                QedeqBo qedeqBo3 = mod2 = this.loadLocalModule(moduleAddress);
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl17 : MonitorExitStatement: MONITOREXIT : var4_4
                this.processDec();
                return qedeqBo3;
            }
            catch (ModuleFileNotFoundException e) {
            }
            catch (XmlFileExceptionList e) {
                Trace.trace((Object)this, "loadModule(ModuleAddress)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", moduleAddress.getURL(), e.getMessage());
                throw e;
            }
            try {
                this.makeLocalCopy(moduleAddress);
            }
            catch (IOException e) {
                Trace.trace((Object)this, "loadModule(ModuleAddress)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", moduleAddress.getURL(), e.getMessage());
                throw this.createXmlFileExceptionList(e);
            }
            try {
                mod = this.loadLocalModule(moduleAddress);
            }
            catch (ModuleFileNotFoundException e) {
                Trace.trace((Object)this, "loadModule(ModuleAddress)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", moduleAddress.getURL(), e.getMessage());
                throw e.createXmlFileExceptionList();
            }
            catch (XmlFileExceptionList e) {
                Trace.trace((Object)this, "loadModule(ModuleAddress)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", moduleAddress.getURL(), e.getMessage());
                throw e;
            }
            qedeqBo = mod;
        }
        this.processDec();
        return qedeqBo;
    }

    /*
     * Exception decompiling
     */
    public final QedeqBo loadModule(QedeqBo module, Specification spec) throws XmlFileExceptionList {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[MONITOR]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final String[] getAllLoadedModules() {
        return this.getModules().getAllLoadedModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadPreviouslySuccessfullyLoadedModules() {
        this.processInc();
        try {
            String[] list = this.kernel.getConfig().getPreviouslyCheckedModules();
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.loadModule(list[i]);
                    continue;
                }
                catch (XmlFileExceptionList e) {
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadAllModulesFromQedeq() {
        this.processInc();
        try {
            String prefix = "http://www.qedeq.org/" + this.kernel.getKernelVersionDirectory() + "/";
            String[] list = new String[]{prefix + "doc/math/qedeq_logic_v1.xml", prefix + "doc/math/qedeq_set_theory_v1.xml", prefix + "doc/math/qedeq_sample1.xml", prefix + "doc/project/qedeq_basic_concept.xml", prefix + "doc/project/qedeq_logic_language.xml", prefix + "sample/qedeq_error_sample_00.xml", prefix + "sample/qedeq_error_sample_01.xml", prefix + "sample/qedeq_error_sample_02.xml", prefix + "sample/qedeq_error_sample_03.xml", prefix + "sample/qedeq_error_sample_04.xml", prefix + "sample/qedeq_sample2_error.xml", prefix + "sample/qedeq_sample3_error.xml", prefix + "sample/qedeq_sample4_error.xml", prefix + "sample/qedeq_sample5_error.xml", prefix + "sample/qedeq_sample6_error.xml", prefix + "sample/qedeq_sample7_error.xml"};
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    this.loadModule(list[i]);
                    continue;
                }
                catch (XmlFileExceptionList e) {
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    public final String getLocalName(ModuleAddress moduleAddress) {
        if (moduleAddress.isFileAddress()) {
            return moduleAddress.getPath() + moduleAddress.getFileName();
        }
        return this.kernel.getBufferDirectory() + "/" + moduleAddress.localizeInFileSystem(moduleAddress.getAddress());
    }

    private final QedeqBo loadLocalModule(ModuleAddress moduleAddress) throws ModuleFileNotFoundException, XmlFileExceptionList {
        DefaultQedeqBo qedeqBo;
        String method = "loadLocalModule";
        String localName = this.getLocalName(moduleAddress);
        File file = new File(localName);
        if (!file.canRead()) {
            try {
                Trace.trace((Object)this, "loadLocalModule", (Object)("file=" + file.getCanonicalPath()));
            }
            catch (IOException e) {
                Trace.trace((Object)this, "loadLocalModule", (Throwable)e);
            }
            throw new ModuleFileNotFoundException("file not found");
        }
        ModuleProperties prop = this.getModules().getModuleProperties(moduleAddress);
        if (prop.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            System.out.println("Adding undefined");
            prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
            ModuleEventLog.getInstance().addModule(prop);
        } else {
            System.out.println("Adding defined");
            prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
            ModuleEventLog.getInstance().stateChanged(prop);
        }
        SaxDefaultHandler handler = new SaxDefaultHandler();
        QedeqHandler simple = new QedeqHandler(handler);
        handler.setBasisDocumentHandler(simple);
        Qedeq qedeq = null;
        SaxParser parser = null;
        try {
            parser = new SaxParser(handler);
        }
        catch (SAXException e) {
            Trace.trace((Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, e);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw this.createXmlFileExceptionList(e);
        }
        catch (ParserConfigurationException e) {
            Trace.trace((Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, e);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw this.createXmlFileExceptionList(e);
        }
        try {
            parser.parse(file);
        }
        catch (XmlFileExceptionList e) {
            Trace.trace((Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, e);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw e;
        }
        qedeq = simple.getQedeq();
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_INTO_MEMORY);
        ModuleEventLog.getInstance().stateChanged(prop);
        try {
            qedeqBo = QedeqBoFactory.createQedeq(file.getAbsolutePath(), qedeq);
            qedeqBo.setModuleAddress(prop.getModuleAddress());
        }
        catch (ModuleDataException e) {
            Trace.trace((Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, e);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw ModuleDataException2XmlFileException.createXmlFileExceptionList(e, qedeq);
        }
        prop.setLoaded(qedeqBo);
        ModuleEventLog.getInstance().stateChanged(prop);
        return qedeqBo;
    }

    /*
     * Loose catch block
     */
    private final synchronized void makeLocalCopy(ModuleAddress moduleAddress) throws IOException {
        block22: {
            int bytesRead;
            String method = "makeLocalCopy";
            Trace.begin(this, "makeLocalCopy");
            ModuleProperties prop = this.getModules().getModuleProperties(moduleAddress);
            if (prop.getLoadingState() == LoadingState.STATE_UNDEFINED) {
                prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
                ModuleEventLog.getInstance().addModule(prop);
            } else {
                prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
                ModuleEventLog.getInstance().stateChanged(prop);
            }
            if (moduleAddress.isFileAddress()) {
                return;
            }
            FileOutputStream out = null;
            InputStream in = null;
            URLConnection connection = moduleAddress.getURL().openConnection();
            in = connection.getInputStream();
            int maximum = connection.getContentLength();
            if (!moduleAddress.getURL().equals(connection.getURL())) {
                throw new FileNotFoundException("\"" + moduleAddress.getURL() + "\" was substituted by " + "\"" + connection.getURL() + "\" from server");
            }
            String localName = this.getLocalName(moduleAddress);
            System.out.println(localName);
            File f = new File(localName).getParentFile();
            f.mkdirs();
            out = new FileOutputStream(this.getLocalName(moduleAddress));
            byte[] buffer = new byte[4096];
            int position = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                int completeness = (position += bytesRead) * 100 / maximum;
                if (completeness < 0) {
                    completeness = 0;
                }
                if (completeness > 100) {
                    completeness = 100;
                }
                prop.setLoadingCompleteness(completeness);
            }
            prop.setLoadingCompleteness(100);
            Object var13_16 = null;
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                in.close();
                break block22;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block22;
                catch (IOException e) {
                    Trace.trace((Object)this, "makeLocalCopy", (Throwable)e);
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        new File(this.getLocalName(moduleAddress)).delete();
                    }
                    catch (Exception ex) {
                        Trace.trace((Object)this, "makeLocalCopy", (Throwable)ex);
                    }
                    prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, e);
                    ModuleEventLog.getInstance().stateChanged(prop);
                    Trace.trace((Object)this, "makeLocalCopy", (Object)("Couldn't access " + moduleAddress.getURL()));
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Trace.end(this, "makeLocalCopy");
                throw throwable;
            }
        }
        Trace.end(this, "makeLocalCopy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processInc() {
        String string = this.syncToken;
        synchronized (string) {
            ++this.processCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processDec() {
        String string = this.syncToken;
        synchronized (string) {
            --this.processCounter;
        }
    }

    public final String getBufferDirectory() {
        return this.kernel.getConfig().getBufferDirectory();
    }

    public final String getGenerationDirectory() {
        return this.kernel.getConfig().getGenerationDirectory();
    }

    public final ModuleProperties getModuleProperties(String address) {
        try {
            ModuleProperties prop = this.getModules().getModuleProperties(address);
            return prop;
        }
        catch (IOException e) {
            Trace.trace((Object)this, "getModuleProperties", (Throwable)e);
            return null;
        }
    }

    private final Modules getModules() {
        return this.modules;
    }

    private XmlFileExceptionList createXmlFileExceptionList(IOException e) {
        return new DefaultXmlFileExceptionList(e);
    }

    private XmlFileExceptionList createXmlFileExceptionList(ParserConfigurationException e) {
        DefaultXmlFileExceptionList list = new DefaultXmlFileExceptionList();
        list.add(e);
        return list;
    }

    private DefaultXmlFileExceptionList createXmlFileExceptionList(SAXException e) {
        DefaultXmlFileExceptionList list = new DefaultXmlFileExceptionList();
        list.add(e);
        return list;
    }
}

