/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.net.URL;
import java.util.Stack;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.common.SyntaxException;
import org.qedeq.kernel.common.SyntaxExceptionList;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.parser.AbstractSimpleHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDefaultHandler
extends DefaultHandler {
    private AbstractSimpleHandler currentHandler;
    private Stack handlerStack = new Stack();
    private AbstractSimpleHandler basisHandler;
    private SyntaxExceptionList errorList;
    private StringBuffer buffer = new StringBuffer(2000);
    private Locator locator;
    private int level;
    private Stack levelStack = new Stack();
    private String currentElementName;
    private URL url;

    public final void setExceptionList(SyntaxExceptionList errorList) {
        this.errorList = errorList;
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public final void setBasisDocumentHandler(AbstractSimpleHandler handler) {
        this.basisHandler = handler;
        this.currentHandler = handler;
        this.handlerStack.clear();
        this.level = 0;
    }

    public final void startDocument() throws SAXException {
        this.sendCharacters();
        this.currentHandler = this.basisHandler;
        this.handlerStack.clear();
        this.level = 0;
        this.currentElementName = null;
    }

    public final void endDocument() throws SAXException {
        this.sendCharacters();
        this.currentElementName = null;
    }

    public final void startElement(String uri, String localName, String qName, Attributes amap) throws SAXException {
        String method = "startElement";
        try {
            Trace.param((Object)this, "startElement", "currentHandler", (Object)this.currentHandler.getClass().getName());
            Trace.param((Object)this, "startElement", "localName", (Object)localName);
            Trace.param((Object)this, "startElement", "qName", (Object)qName);
            if (this.handlerStack.empty() && this.level == 0) {
                this.currentHandler.init();
            }
            ++this.level;
            this.sendCharacters();
            this.currentElementName = localName;
            SimpleAttributes attributes = new SimpleAttributes();
            for (int i = 0; i < amap.getLength(); ++i) {
                attributes.add(amap.getQName(i), amap.getValue(i));
            }
            Trace.param((Object)this, "startElement", "attributes", (Object)attributes);
            this.currentHandler.startElement(qName, attributes);
        }
        catch (SyntaxException e) {
            Trace.trace((Object)this, "startElement", (Throwable)e);
            this.setLocationInformation(e);
            this.errorList.add(e);
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "startElement", (Throwable)e);
            SyntaxException ex = SyntaxException.createByRuntimeException(e);
            this.setLocationInformation(ex);
            this.errorList.add(ex);
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        SyntaxException ex;
        this.sendCharacters();
        String method = "endElement";
        try {
            Trace.param((Object)this, "endElement", "currentHandler", (Object)this.currentHandler.getClass().getName());
            Trace.param((Object)this, "endElement", "localName", (Object)localName);
            this.currentHandler.endElement(localName);
        }
        catch (SyntaxException e) {
            Trace.trace((Object)this, "endElement", (Throwable)e);
            this.setLocationInformation(e);
            this.errorList.add(e);
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "endElement", (Throwable)e);
            ex = SyntaxException.createByRuntimeException(e);
            this.setLocationInformation(ex);
            this.errorList.add(ex);
        }
        try {
            this.currentElementName = null;
            --this.level;
            if (this.level <= 0) {
                this.restoreHandler(localName);
            }
        }
        catch (SyntaxException e) {
            Trace.trace((Object)this, "endElement", (Throwable)e);
            this.setLocationInformation(e);
            this.errorList.add(e);
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "endElement", (Throwable)e);
            ex = SyntaxException.createByRuntimeException(e);
            this.setLocationInformation(ex);
            this.errorList.add(ex);
        }
    }

    public final void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    private void sendCharacters() throws SAXException {
        try {
            if (this.buffer.length() > 0) {
                String str = this.buffer.toString().trim();
                this.buffer.setLength(0);
                if (str.length() > 0) {
                    this.currentHandler.characters(this.currentElementName, str);
                }
            }
        }
        catch (SyntaxException e) {
            Trace.trace((Object)this, "startElement", (Throwable)e);
            this.setLocationInformation(e);
            this.errorList.add(e);
        }
        catch (RuntimeException e) {
            Trace.trace((Object)this, "startElement", (Throwable)e);
            SyntaxException ex = SyntaxException.createByRuntimeException(e);
            this.setLocationInformation(ex);
            this.errorList.add(ex);
        }
    }

    public final void changeHandler(AbstractSimpleHandler newHandler, String elementName, SimpleAttributes attributes) throws SyntaxException {
        this.handlerStack.push(this.currentHandler);
        this.levelStack.push(new Integer(this.level));
        this.currentHandler = newHandler;
        this.level = 0;
        ++this.level;
        this.currentHandler.init();
        this.currentHandler.startElement(elementName, attributes);
    }

    private final void restoreHandler(String elementName) throws SyntaxException {
        while (this.level <= 0 && !this.handlerStack.empty()) {
            this.currentHandler = (AbstractSimpleHandler)this.handlerStack.pop();
            this.level = (Integer)this.levelStack.pop();
            this.currentHandler.endElement(elementName);
            --this.level;
        }
        if (this.handlerStack.empty()) {
            Trace.trace((Object)this, "restoreHandler", (Object)"no handler to restore");
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final SAXParseException createSAXParseException(Exception e) {
        return new SAXParseException(null, this.locator, e);
    }

    public final SAXParseException createSAXParseException(String message) {
        return new SAXParseException(message, this.locator);
    }

    private final void setLocationInformation(SyntaxException e) {
        if (this.locator != null && this.url != null) {
            e.setErrorPosition(new SourcePosition(this.url, this.locator.getLineNumber(), this.locator.getColumnNumber()));
        }
    }

    public final void setUrl(URL url) {
        this.url = url;
    }
}

