/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.utility;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.qedeq.kernel.utility.ReplaceUtility;

public final class IoUtility {
    private IoUtility() {
    }

    public static String loadFile(String filename) throws IOException {
        StringBuffer buffer = new StringBuffer();
        IoUtility.loadFile(filename, buffer);
        return buffer.toString();
    }

    public static void loadFile(String filename, StringBuffer buffer) throws IOException {
        IoUtility.loadFile(new File(filename), buffer);
    }

    public static void loadStream(InputStream in, StringBuffer buffer) throws IOException {
        int c;
        buffer.setLength(0);
        while ((c = in.read()) >= 0) {
            buffer.append((char)c);
        }
    }

    public static void loadFile(File file, StringBuffer buffer) throws IOException {
        int size = (int)file.length();
        buffer.setLength(0);
        FileReader in = new FileReader(file);
        char[] data = new char[size];
        for (int charsread = 0; charsread < size; charsread += in.read(data, charsread, size - charsread)) {
        }
        in.close();
        buffer.insert(0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadFileBinary(File file) throws IOException {
        int size = (int)file.length();
        FileInputStream in = new FileInputStream(file);
        try {
            int read;
            byte[] data = new byte[size];
            for (int charsread = 0; charsread < size; charsread += read) {
                read = in.read(data, charsread, size - charsread);
                if (read != -1) continue;
                byte[] result = new byte[charsread];
                System.arraycopy(data, 0, result, 0, charsread);
                byte[] byArray = result;
                return byArray;
            }
            in.close();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            IoUtility.closeStream(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(URL url, StringBuffer buffer) throws IOException {
        InputStream in = null;
        BufferedReader dis = null;
        try {
            int i;
            in = url.openStream();
            dis = new BufferedReader(new InputStreamReader(in));
            while ((i = dis.read()) != -1) {
                buffer.append((char)i);
            }
        }
        catch (Throwable throwable) {
            IoUtility.closeStream(in);
            IoUtility.closeReader(dis);
            throw throwable;
        }
        IoUtility.closeStream(in);
        IoUtility.closeReader(dis);
    }

    public static final Reader stringToReader(String data) {
        try {
            return new InputStreamReader(new ByteArrayInputStream(data.getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(String filename, String text) throws IOException {
        IoUtility.saveFile(new File(filename), text);
    }

    public static void saveFile(String filename, StringBuffer text) throws IOException {
        IoUtility.saveFile(new File(filename), text.toString());
    }

    public static void saveFile(File file, StringBuffer text) throws IOException {
        IoUtility.saveFile(file, text.toString());
    }

    public static void saveFile(File file, String text) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(text);
        out.close();
    }

    public static void saveFileBinary(File file, byte[] data) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        out.write(data);
        out.close();
    }

    public static void copyFile(File from, File to) throws IOException {
        int length;
        if (from.getAbsoluteFile().equals(to.getAbsoluteFile())) {
            return;
        }
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        byte[] data = new byte[8192];
        while ((length = in.read(data)) != -1) {
            out.write(data, 0, length);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFiles(File from, File with) throws IOException {
        boolean bl;
        if (from == null && with == null) {
            return true;
        }
        if (from == null || with == null) {
            return false;
        }
        if (from.getAbsoluteFile().equals(with.getAbsoluteFile())) {
            return true;
        }
        if (from.length() != with.length()) {
            return false;
        }
        byte[] dataOne = new byte[8192];
        byte[] dataTwo = new byte[8192];
        FileInputStream one = null;
        FileInputStream two = null;
        try {
            int length;
            one = new FileInputStream(from);
            two = new FileInputStream(with);
            while ((length = one.read(dataOne)) != -1) {
                if (length == two.read(dataTwo)) break block9;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            IoUtility.closeStream(one);
            IoUtility.closeStream(two);
            throw throwable;
        }
        {
            block9: {
                IoUtility.closeStream(one);
                IoUtility.closeStream(two);
                return bl;
            }
            if (Arrays.equals(dataOne, dataTwo)) continue;
            boolean bl2 = false;
            IoUtility.closeStream(one);
            IoUtility.closeStream(two);
            return bl2;
        }
        boolean bl3 = true;
        IoUtility.closeStream(one);
        IoUtility.closeStream(two);
        return bl3;
    }

    public static String quote(String unquoted) {
        String result = "\"";
        for (int i = 0; i < unquoted.length(); ++i) {
            result = unquoted.charAt(i) == '\"' ? result + "\"\"" : result + unquoted.charAt(i);
        }
        result = result + '\"';
        return result;
    }

    public static boolean isLetterDigitString(String text) {
        if (text.length() <= 0) {
            return false;
        }
        if (!Character.isLetter(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteDir(File directory) {
        File candir;
        try {
            candir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(directory.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (deleted || !file.isDirectory()) continue;
                IoUtility.deleteDir(file);
            }
        }
        return directory.delete();
    }

    public static StringBuffer getSpaces(int length) {
        StringBuffer buffer = new StringBuffer(length >= 0 ? length : 0);
        for (int i = 0; i < length; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    public static String getClassName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public static void printAllSystemProperties() {
        Properties sysprops = System.getProperties();
        Enumeration<?> e = sysprops.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = sysprops.getProperty(key);
            System.out.println(key + "=" + value);
        }
    }

    public static File getUserHomeDirectory() {
        return new File((String)System.getProperties().get("user.home"));
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createNecessaryDirectories(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    public static final String createRelativePath(File orgin, File next) {
        try {
            if (orgin.equals(next)) {
                return "";
            }
            try {
                String org = orgin.getCanonicalPath().replace('\\', '/');
                if (orgin.isDirectory() && !org.endsWith("/")) {
                    org = org + "/";
                }
                String nex = next.getCanonicalPath().replace('\\', '/');
                if (next.isDirectory() && !nex.endsWith("/")) {
                    nex = nex + "/";
                }
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j));
                    return result.toString();
                }
                return "/" + nex;
            }
            catch (RuntimeException e) {
                return next.toString();
            }
        }
        catch (IOException e) {
            return next.toString();
        }
    }

    public static void waitln() {
        System.out.println("\n..press <return> to continue");
        try {
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void deleteLineLeadingWhitespace(StringBuffer buffer) {
        int start = -1;
        while (0 <= (start = buffer.indexOf("\n", start + 1)) && (start + 1 >= buffer.length() || '\n' == buffer.charAt(start + 1))) {
        }
        if (start >= 0) {
            int next;
            for (next = start + 1; next < buffer.length() && Character.isWhitespace(buffer.charAt(next)) && '\n' != buffer.charAt(next); ++next) {
            }
            String empty = buffer.substring(start, next);
            if (empty.length() > 0) {
                ReplaceUtility.replace(buffer, empty, "\n");
            }
        }
    }

    public static final File getStartDirectory(String application) {
        File startDirectory;
        String webStart = (String)System.getProperties().get("javawebstart.version");
        if (webStart != null) {
            String userHomeWS = System.getProperties().get("jnlpx.deployment.user.home") != null ? (String)System.getProperties().get("jnlpx.deployment.user.home") : "";
            String userHome = System.getProperties().get("user.home") != null ? (String)System.getProperties().get("user.home") : "";
            startDirectory = new File(new File(userHomeWS.length() != 0 ? userHomeWS : userHome), "." + application);
        } else {
            startDirectory = new File(".");
        }
        return startDirectory;
    }
}

