/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.latex.Qedeq2Xml;
import org.qedeq.kernel.rel.test.text.KernelFacade;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.TextOutput;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultXmlFileExceptionList;

public final class Xml2Xml {
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Xml;
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Latex;

    private Xml2Xml() {
    }

    public static void main(String[] args) {
        String from = null;
        String to = null;
        if (args.length == 0) {
            Xml2Xml.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    Xml2Xml.printProgramInformation();
                    return;
                }
                if (option.equals("to")) {
                    if (i + 1 >= args.length) {
                        Xml2Xml.printArgumentError("\"-to\" must be followed by a filename.");
                        return;
                    }
                    to = args[i + 1];
                    ++i;
                    continue;
                }
                Xml2Xml.printArgumentError("Unknown option: " + option);
                return;
            }
            if (from != null) {
                Xml2Xml.printArgumentError("XML file name must only be specified once.");
                return;
            }
            from = args[i];
        }
        if (from == null) {
            Xml2Xml.printArgumentError("XML file must be specified.");
            return;
        }
        System.out.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml) + ", running on: " + KernelFacade.getKernelContext().getDescriptiveKernelVersion());
        try {
            System.out.println("Successfully generated:\n" + Xml2Xml.generate(from, to));
        }
        catch (XmlFileExceptionList e) {
            System.out.println(e);
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    public static void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml) + " - create LaTeX document");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("-------------------");
        System.err.println("[-h] <xmlFile> [-to <latexFile>]");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program creates a XML file out of *Hilbert II* XML files.");
        System.err.println("If no \"-to\" filename was given, the resulting XML file is at the same");
        System.err.println("place as the original file but has the extension \"_.xml\".");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h         writes this text and returns");
        System.err.println("<xmlFile>  XML file that fulfils the XSD from \"http://www.qedeq.org/" + KernelFacade.getKernelContext().getKernelVersionDirectory() + "\"");
        System.err.println("-to <file> write result into this file");
        System.err.println();
        System.err.println("Parameter Examples");
        System.err.println("------------------");
        System.err.println("sample/qedeq_basic_concept.xml");
        System.err.println();
        System.err.println("Further information");
        System.err.println("-------------------");
        System.err.println("For more information about *Hilbert II* look at:");
        System.err.println("\thttp://www.qedeq.org/");
        System.err.println();
    }

    private static void printArgumentError(String message) {
        System.err.println(">>>ERROR reason:");
        System.err.println(message);
        System.err.println();
        System.err.println(">>>Calling convention:");
        Xml2Xml.printProgramInformation();
    }

    public static String generate(String from, String to) throws XmlFileExceptionList {
        return Xml2Xml.generate(from != null ? new File(from) : null, to != null ? new File(to) : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generate(File from, File to) throws XmlFileExceptionList {
        Class clazz;
        String string;
        block17: {
            block15: {
                String method = "generate(String, String, String, String)";
                File destination = null;
                File source = null;
                QedeqBo qedeqBo = null;
                try {
                    Trace.begin(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)");
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", "from", (Object)from);
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", "to", (Object)to);
                    source = from;
                    if (to != null) {
                        destination = to.getCanonicalFile();
                    } else {
                        String xml = source.getName();
                        if (xml.toLowerCase().endsWith(".xml")) {
                            xml = xml.substring(0, xml.length() - 4);
                        }
                        destination = new File(source.getParentFile(), xml + "_.xml").getCanonicalFile();
                    }
                }
                catch (IOException e) {
                    Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                    throw new DefaultXmlFileExceptionList(e);
                }
                TextOutput printer = null;
                try {
                    block14: {
                        try {
                            qedeqBo = KernelFacade.getKernelContext().loadModule(IoUtility.toUrl(source.getCanonicalFile()).toExternalForm());
                            IoUtility.createNecessaryDirectories(destination);
                            FileOutputStream outputStream = new FileOutputStream(destination);
                            printer = new TextOutput(destination.getName(), outputStream);
                            Qedeq2Xml.print(source.getCanonicalPath(), qedeqBo, printer);
                            string = destination.getCanonicalPath();
                            Object var10_13 = null;
                            if (printer == null) break block14;
                        }
                        catch (IOException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            throw new DefaultXmlFileExceptionList(e);
                        }
                        catch (RuntimeException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            throw new DefaultXmlFileExceptionList(e);
                        }
                        catch (ModuleDataException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "context", (Object)e.getContext());
                            throw ModuleDataException2XmlFileException.createXmlFileExceptionList(e, qedeqBo);
                        }
                        printer.close();
                    }
                    if (class$org$qedeq$kernel$rel$test$text$Xml2Xml != null) break block15;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (printer != null) {
                        printer.close();
                    }
                    Trace.end(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)");
                    throw throwable;
                }
                clazz = class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml");
                break block17;
            }
            clazz = class$org$qedeq$kernel$rel$test$text$Xml2Xml;
        }
        Trace.end(clazz, "generate(String, String, String, String)");
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

