/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.latex.Qedeq2Latex;
import org.qedeq.kernel.rel.test.text.KernelFacade;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.TextOutput;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultXmlFileExceptionList;

public final class Xml2Latex {
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Latex;

    private Xml2Latex() {
    }

    public static void main(String[] args) {
        String language = null;
        String level = null;
        String from = null;
        String to = null;
        if (args.length == 0) {
            Xml2Latex.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    Xml2Latex.printProgramInformation();
                    return;
                }
                if (option.equals("language")) {
                    if (i + 1 >= args.length) {
                        Xml2Latex.printArgumentError("\"-language\" must be followed by a language.");
                        return;
                    }
                    language = args[i + 1];
                    ++i;
                    continue;
                }
                if (option.equals("level")) {
                    if (i + 1 >= args.length) {
                        Xml2Latex.printArgumentError("\"-level\" must be followed by a level.");
                        return;
                    }
                    level = args[i + 1];
                    ++i;
                    continue;
                }
                if (option.equals("to")) {
                    if (i + 1 >= args.length) {
                        Xml2Latex.printArgumentError("\"-to\" must be followed by a filename.");
                        return;
                    }
                    to = args[i + 1];
                    ++i;
                    continue;
                }
                Xml2Latex.printArgumentError("Unknown option: " + option);
                return;
            }
            if (from != null) {
                Xml2Latex.printArgumentError("XML file name must only be specified once.");
                return;
            }
            from = args[i];
        }
        if (from == null) {
            Xml2Latex.printArgumentError("XML file must be specified.");
            return;
        }
        System.out.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex) + ", running on: " + KernelFacade.getKernelContext().getDescriptiveKernelVersion());
        try {
            System.out.println("Successfully generated:\n" + Xml2Latex.generate(from, to, language, level));
        }
        catch (XmlFileExceptionList e) {
            System.out.println(e);
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    public static void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex) + " - create LaTeX document");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("-------------------");
        System.err.println("[-h] [-language <language>] [-level <level>] <xmlFile> [-to <latexFile>]");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program creates a LaTeX file out of *Hilbert II* XML files.");
        System.err.println("If no \"-to\" filename was given, the resulting LaTeX file is at the same");
        System.err.println("place as the original file but has the extension \".tex\".");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h         writes this text and returns");
        System.err.println("-language  set the language filter (default: \"en\")");
        System.err.println("-level     the level filter (default: \"1\")");
        System.err.println("<xmlFile>  XML file that fulfils the XSD from \"http://www.qedeq.org/" + KernelFacade.getKernelContext().getKernelVersionDirectory() + "\"");
        System.err.println("-to <file> write result into this file");
        System.err.println();
        System.err.println("Parameter Examples");
        System.err.println("------------------");
        System.err.println("sample/qedeq_basic_concept.xml");
        System.err.println();
        System.err.println("Further information");
        System.err.println("-------------------");
        System.err.println("For more information about *Hilbert II* look at:");
        System.err.println("\thttp://www.qedeq.org/");
        System.err.println();
    }

    private static void printArgumentError(String message) {
        System.err.println(">>>ERROR reason:");
        System.err.println(message);
        System.err.println();
        System.err.println(">>>Calling convention:");
        Xml2Latex.printProgramInformation();
    }

    public static String generate(String from, String to, String language, String level) throws XmlFileExceptionList {
        return Xml2Latex.generate(from != null ? new File(from) : null, to != null ? new File(to) : null, language, level);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generate(File from, File to, String language, String level) throws XmlFileExceptionList {
        Class clazz;
        String string;
        block18: {
            block16: {
                String method = "generate(String, String, String, String)";
                File destination = null;
                File source = null;
                QedeqBo qedeqBo = null;
                try {
                    Trace.begin(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)");
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "from", (Object)from);
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "to", (Object)to);
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "language", (Object)language);
                    Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "level", (Object)level);
                    source = from.getCanonicalFile();
                    if (to != null) {
                        destination = to.getCanonicalFile();
                    } else {
                        String tex = source.getName();
                        if (tex.toLowerCase().endsWith(".xml")) {
                            tex = tex.substring(0, tex.length() - 4);
                        }
                        if (language != null && language.length() > 0) {
                            tex = tex + "_" + language;
                        }
                        destination = new File(source.getParentFile(), tex + ".tex").getCanonicalFile();
                    }
                }
                catch (IOException e) {
                    Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                    throw new DefaultXmlFileExceptionList(e);
                }
                TextOutput printer = null;
                try {
                    block15: {
                        try {
                            qedeqBo = KernelFacade.getKernelContext().loadModule(IoUtility.toUrl(source.getCanonicalFile()).toExternalForm());
                            IoUtility.createNecessaryDirectories(destination);
                            FileOutputStream outputStream = new FileOutputStream(destination);
                            printer = new TextOutput(destination.getName(), outputStream);
                            Qedeq2Latex.print(source.getAbsolutePath(), qedeqBo, printer, language, level);
                            string = destination.getCanonicalPath();
                            Object var12_15 = null;
                            if (printer == null) break block15;
                        }
                        catch (IOException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            throw new DefaultXmlFileExceptionList(e);
                        }
                        catch (RuntimeException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            throw new DefaultXmlFileExceptionList(e);
                        }
                        catch (ModuleDataException e) {
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                            Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "context", (Object)e.getContext());
                            throw ModuleDataException2XmlFileException.createXmlFileExceptionList(e, qedeqBo);
                        }
                        printer.close();
                    }
                    if (class$org$qedeq$kernel$rel$test$text$Xml2Latex != null) break block16;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (printer != null) {
                        printer.close();
                    }
                    Trace.end(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)");
                    throw throwable;
                }
                clazz = class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Latex.class$("org.qedeq.kernel.rel.test.text.Xml2Latex");
                break block18;
            }
            clazz = class$org$qedeq$kernel$rel$test$text$Xml2Latex;
        }
        Trace.end(clazz, "generate(String, String, String, String)");
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

