/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.qedeq.kernel.common.XmlFileException;
import org.qedeq.kernel.common.XmlFileExceptionList;
import org.qedeq.kernel.rel.test.gui.CPTextField;
import org.qedeq.kernel.rel.test.gui.Parameter;
import org.qedeq.kernel.rel.test.gui.ParameterList;
import org.qedeq.kernel.rel.test.gui.ParserPane;
import org.qedeq.kernel.rel.test.gui.QedeqPane;
import org.qedeq.kernel.rel.test.text.KernelFacade;
import org.qedeq.kernel.rel.test.text.Xml2Latex;
import org.qedeq.kernel.rel.test.text.Xml2Wiki;
import org.qedeq.kernel.rel.test.text.Xml2Xml;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;

public final class StarterDialog
extends JFrame {
    private static final int CONTENTS_WIDTH = 600;
    private static final int CONTENT_HEIGHT = 17;
    private static final int MARGIN_X = 33;
    private final ParameterList parameterList;
    private JTextArea result;
    private int y;
    private Parameter kind;
    private Parameter from;
    private Parameter language;
    private Parameter level;
    private File configFile;
    private XmlFileException errorPosition;
    private JButton edit;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StarterDialog(String title, String configLocation) {
        super(title);
        String method = "StarterDialog(String, ParameterList)";
        this.parameterList = new ParameterList();
        ArrayList<String> list = new ArrayList<String>();
        list.add("tex");
        list.add("wiki");
        list.add("txt");
        list.add("xml");
        this.kind = new Parameter("kind", "Result Type", "Resulting file(s) shall be of this type.", "tex", "tex", list);
        this.parameterList.add(this.kind);
        this.from = new Parameter("from", "Qedeq XML File", class$java$io$File == null ? (class$java$io$File = StarterDialog.class$("java.io.File")) : class$java$io$File, "Convert this XML file into LaTeX.", "sample/qedeq_basic_concept.xml");
        this.parameterList.add(this.from);
        this.language = new Parameter("language", "Language Filter", class$java$lang$String == null ? (class$java$lang$String = StarterDialog.class$("java.lang.String")) : class$java$lang$String, "Filter for this language. (\"en\" and maybe \"de\" occur in the sample texts.)", "en");
        this.parameterList.add(this.language);
        this.level = new Parameter("level", "Level Filter", class$java$lang$String == null ? (class$java$lang$String = StarterDialog.class$("java.lang.String")) : class$java$lang$String, "Filter for this level (not supported yet).", "1");
        this.configFile = new File(configLocation);
        try {
            this.parameterList.fill(this.configFile);
        }
        catch (IOException e) {
            Trace.trace((Object)this, "StarterDialog(String, ParameterList)", (Throwable)e);
        }
        try {
            Trace.begin(this, "StarterDialog(String, ParameterList)");
            this.setupView();
            this.pack();
            this.setSize(666, this.y);
        }
        catch (Throwable e) {
            Trace.trace((Object)this, "StarterDialog(String, ParameterList)", e);
            e.printStackTrace();
        }
        finally {
            Trace.end(this, "StarterDialog(String, ParameterList)");
        }
    }

    public final void setupView() {
        int startY;
        this.y = startY = 21;
        int deltay = 40;
        Container contents = this.getContentPane();
        contents.removeAll();
        contents.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StarterDialog.this.shutdown();
            }
        });
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Parameter parameter;
            if ((class$java$lang$Boolean == null ? StarterDialog.class$("java.lang.Boolean") : class$java$lang$Boolean).equals((parameter = this.parameterList.get(i)).getType())) {
                this.addCheckBox(parameter);
                this.y += deltay;
                continue;
            }
            if ((class$java$lang$String == null ? StarterDialog.class$("java.lang.String") : class$java$lang$String).equals(parameter.getType())) {
                this.addTextField(parameter);
                this.y += deltay;
                continue;
            }
            if ((class$java$io$File == null ? StarterDialog.class$("java.io.File") : class$java$io$File).equals(parameter.getType())) {
                this.addFileSelector(parameter);
                this.y += deltay;
                continue;
            }
            if (!(class$java$util$List == null ? StarterDialog.class$("java.util.List") : class$java$util$List).equals(parameter.getType())) continue;
            this.addListField(parameter);
            this.y += deltay;
        }
        this.result = new JTextArea();
        this.result.setToolTipText("Shows transformation result. If here is any error described just a click on this field opens an viewer with the error location.");
        this.result.setFont(new Font("monospaced", 0, this.result.getFont().getSize()));
        this.result.setAutoscrolls(true);
        this.result.setCaretPosition(0);
        this.result.setEditable(false);
        this.result.getCaret().setVisible(false);
        this.result.setFocusable(true);
        this.result.setForeground(Color.RED);
        this.result.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                StarterDialog.this.openTextFileAtPosition();
            }
        });
        JScrollPane scroller = new JScrollPane(this.result);
        scroller.setBounds(33, this.y, 600, 85);
        contents.add(scroller);
        this.y += 85 + deltay;
        this.y += deltay;
        JButton dflt = new JButton("Default");
        contents.add(dflt);
        dflt.setBounds(33, this.y, 90, 21);
        dflt.setToolTipText("Resets all parameters to default values.");
        dflt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.parameterList.resetToDefaultValues();
                StarterDialog.this.setupView();
            }
        });
        JButton parser = new JButton("Formula Parser");
        contents.add(parser);
        parser.setBounds(175, this.y, 130, 21);
        parser.setToolTipText("Parser formula into QEDEQ format. Converts LaTeX formulas into QEDEQ XML.");
        parser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserPane parserPane;
                try {
                    parserPane = new ParserPane();
                }
                catch (XmlFileExceptionList e) {
                    Trace.trace((Object)this, "actionPerformed", (Throwable)e);
                    return;
                }
                parserPane.show();
                parserPane.updateView();
            }
        });
        this.edit = new JButton("Edit");
        contents.add(this.edit);
        this.edit.setEnabled(false);
        this.edit.setBounds(322, this.y, 90, 21);
        this.edit.setToolTipText("Edit file. Only enabled if an transformation failed.");
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.openTextFileAtPosition();
            }
        });
        JButton ok = new JButton("Start");
        contents.add(ok);
        ok.setBounds(443, this.y, 90, 21);
        ok.setToolTipText("Starts the application.");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String method = "actionPerformed";
                try {
                    StarterDialog.this.setResultMessage(true, "generating");
                    KernelFacade.getKernelContext().removeAllModules();
                    if ("tex".equals(StarterDialog.this.kind.getStringValue())) {
                        String generated = Xml2Latex.generate(StarterDialog.this.from.getFileValue(), null, StarterDialog.this.language.getStringValue(), StarterDialog.this.level.getStringValue());
                        Trace.trace((Object)this, "actionPerformed", (Object)("successfully generated: " + generated));
                        StarterDialog.this.setResultMessage(true, "successfully generated:\n\t" + generated);
                    } else if ("wiki".equals(StarterDialog.this.kind.getStringValue())) {
                        Xml2Wiki.generate(StarterDialog.this.from.getFileValue(), null, StarterDialog.this.language.getStringValue(), StarterDialog.this.level.getStringValue());
                        Trace.trace((Object)this, "actionPerformed", (Object)"successfully generated files");
                        StarterDialog.this.setResultMessage(true, "successfully generated files");
                    } else if ("xml".equals(StarterDialog.this.kind.getStringValue())) {
                        Xml2Xml.generate(StarterDialog.this.from.getFileValue(), null);
                        Trace.trace((Object)this, "actionPerformed", (Object)"successfully generated files");
                        StarterDialog.this.setResultMessage(true, "successfully generated files");
                    } else {
                        Trace.trace((Object)this, "actionPerformed", (Object)("format not yet supported: " + StarterDialog.this.kind.getCurrentStringValue()));
                        StarterDialog.this.setResultMessage(false, "format not yet supported:\n\t" + StarterDialog.this.kind.getCurrentStringValue());
                    }
                }
                catch (XmlFileExceptionList e) {
                    Trace.trace((Object)this, "actionPerformed", (Throwable)e);
                    if (e.size() > 0) {
                        StarterDialog.this.errorPosition = e.get(0);
                        StarterDialog.this.setResultMessage(false, StarterDialog.this.errorPosition.getDescription());
                    } else {
                        StarterDialog.this.errorPosition = new XmlFileException(StarterDialog.this.from.getFileValue(), (Exception)e);
                        StarterDialog.this.setResultMessage(false, StarterDialog.this.errorPosition.getDescription());
                    }
                }
                catch (Exception e) {
                    Trace.trace((Object)this, "actionPerformed", (Throwable)e);
                    StarterDialog.this.errorPosition = new XmlFileException(StarterDialog.this.from.getFileValue(), e);
                    StarterDialog.this.setResultMessage(false, StarterDialog.this.errorPosition.getDescription());
                }
                catch (Error e) {
                    Trace.trace((Object)this, "actionPerformed", (Throwable)e);
                    StarterDialog.this.shutdown();
                }
                Trace.trace(class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui == null ? (class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui = StarterDialog.class$("org.qedeq.kernel.rel.test.gui.Xml2OtherGui")) : class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui, "actionPerformed", (Object)"saving parameters");
                IoUtility.createNecessaryDirectories(StarterDialog.this.configFile);
                try {
                    StarterDialog.this.parameterList.save(StarterDialog.this.configFile);
                }
                catch (IOException e) {
                    Trace.trace(class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui == null ? (class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui = StarterDialog.class$("org.qedeq.kernel.rel.test.gui.Xml2OtherGui")) : class$org$qedeq$kernel$rel$test$gui$Xml2OtherGui, "actionPerformed", (Throwable)e);
                }
            }
        });
        JButton cancel = new JButton("Exit");
        contents.add(cancel);
        cancel.setBounds(543, this.y, 90, 21);
        cancel.setToolTipText("Exits the application.");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.shutdown();
            }
        });
        this.y += deltay;
        this.y += 21;
    }

    private void setResultMessage(boolean ok, String message) {
        if (ok) {
            this.result.setForeground(Color.GREEN);
        } else {
            this.result.setForeground(Color.RED);
        }
        this.result.setText(message);
        this.result.setCaretPosition(0);
        this.edit.setEnabled(!ok);
    }

    private void setEmptyResultMessage() {
        this.result.setForeground(Color.BLACK);
        this.result.setText("");
        this.result.setCaretPosition(0);
        this.errorPosition = null;
    }

    private void addFileSelector(final Parameter parameter) {
        Container contents = this.getContentPane();
        JLabel label = new JLabel(parameter.getLabel());
        contents.add(label);
        label.setBounds(33, this.y, 600, 17);
        this.y += 17;
        final CPTextField textField = new CPTextField();
        if (parameter.getFileValue() != null) {
            try {
                textField.setText(parameter.getFileValue().getCanonicalPath());
            }
            catch (IOException e) {
                textField.setText(parameter.getStringValue());
            }
        }
        textField.setEditable(false);
        textField.setBounds(33, this.y, 500, 17);
        textField.setToolTipText(parameter.getComment());
        contents.add(textField);
        JButton choose = new JButton("Choose");
        contents.add(choose);
        choose.setBounds(543, this.y, 90, 17);
        choose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    StarterDialog.this.setEmptyResultMessage();
                    File file = parameter.getFileValue();
                    if (!file.exists()) {
                        file = new File(".");
                    }
                    JFileChooser chooser = new JFileChooser(new File(file.getCanonicalPath()));
                    FileFilter filter = new FileFilter(this){
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            return f.getName().toLowerCase().endsWith(".xml");
                        }

                        public String getDescription() {
                            return "XML files";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(0);
                    int returnVal = chooser.showOpenDialog(StarterDialog.this);
                    if (returnVal == 0) {
                        textField.setText(chooser.getSelectedFile().getAbsolutePath());
                        parameter.setStringValue(IoUtility.createRelativePath(new File("."), chooser.getSelectedFile()));
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(StarterDialog.this, e.getMessage(), "Alert", 0);
                }
            }
        });
    }

    private void addTextField(final Parameter parameter) {
        Container contents = this.getContentPane();
        JLabel label = new JLabel(parameter.getLabel());
        contents.add(label);
        label.setBounds(33, this.y, 600, 17);
        this.y += 17;
        final CPTextField textField = new CPTextField();
        if (parameter.getStringValue() != null) {
            textField.setText(parameter.getStringValue());
        }
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.setEmptyResultMessage();
                parameter.setValue(textField.getText());
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                StarterDialog.this.setEmptyResultMessage();
                parameter.setValue(textField.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                StarterDialog.this.setEmptyResultMessage();
                parameter.setValue(textField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                StarterDialog.this.setEmptyResultMessage();
                parameter.setValue(textField.getText());
            }
        });
        contents.add(textField);
        textField.setBounds(33, this.y, 100, 17);
        textField.setToolTipText(parameter.getComment());
    }

    private void addListField(final Parameter parameter) {
        Container contents = this.getContentPane();
        JLabel label = new JLabel(parameter.getLabel());
        contents.add(label);
        label.setBounds(33, this.y, 600, 17);
        this.y += 17;
        Vector vector = new Vector(parameter.getList());
        final JComboBox comboBox = new JComboBox(vector);
        if (parameter.getStringValue() != null) {
            comboBox.setSelectedItem(parameter.getStringValue());
        }
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.setEmptyResultMessage();
                System.out.println("selected: " + comboBox.getSelectedItem().toString());
                parameter.setValue(comboBox.getSelectedItem().toString());
            }
        });
        contents.add(comboBox);
        comboBox.setBounds(33, this.y, 100, 17);
        comboBox.setToolTipText(parameter.getComment());
    }

    private void addCheckBox(final Parameter parameter) {
        Container contents = this.getContentPane();
        final JCheckBox checkBox = new JCheckBox(" " + parameter.getLabel());
        checkBox.setSelected(Boolean.TRUE.equals(parameter.getValue()));
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StarterDialog.this.setEmptyResultMessage();
                parameter.setValue(checkBox.isSelected());
            }
        });
        contents.add(checkBox);
        checkBox.setBounds(33, this.y, 600, 17);
        checkBox.setToolTipText(parameter.getComment());
    }

    private void shutdown() {
        String method = "shutdown()";
        this.dispose();
        Trace.trace((Object)this, "shutdown()", (Object)"calling System.exit");
        System.exit(0);
    }

    private void openTextFileAtPosition() {
        if (this.errorPosition != null && this.errorPosition.getSourceArea() != null) {
            QedeqPane qedeq = new QedeqPane(this.errorPosition);
            qedeq.show();
            qedeq.updateView();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

