/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.qedeq.kernel.rel.test.gui.Parameter;

public class ParameterList {
    private final List list = new ArrayList();

    public void add(Parameter parameter) {
        this.list.add(parameter);
    }

    public final int size() {
        return this.list.size();
    }

    public final Parameter get(int i) {
        return (Parameter)this.list.get(i);
    }

    public final Parameter get(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(name)) continue;
            return this.get(i);
        }
        throw new NullPointerException("parameter \"" + name + "\" not found");
    }

    public final void fill(File file) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        for (int i = 0; i < this.size(); ++i) {
            Parameter parameter = this.get(i);
            if (properties.getProperty(parameter.getName()) == null) continue;
            parameter.setStringValue(properties.getProperty(parameter.getName()));
        }
    }

    public void save(File file) throws IOException {
        Properties properties = new Properties();
        for (int i = 0; i < this.size(); ++i) {
            Parameter parameter = this.get(i);
            if (parameter.getStringValue() == null) continue;
            properties.setProperty(parameter.getName(), parameter.getStringValue());
        }
        properties.store(new FileOutputStream(file), null);
    }

    public void resetToDefaultValues() {
        for (int i = 0; i < this.size(); ++i) {
            Parameter parameter = this.get(i);
            parameter.resetToDefault();
        }
    }
}

