/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.parser.Operator;
import org.qedeq.kernel.parser.TermAtom;
import org.qedeq.kernel.utility.IoUtility;

public class Term {
    private final Operator operator;
    private final List arguments;
    private final TermAtom atom;

    public Term(TermAtom atom) {
        this.operator = null;
        this.arguments = null;
        this.atom = atom;
    }

    public Term(Operator operator) {
        this.operator = operator;
        this.arguments = new ArrayList();
        this.atom = null;
    }

    public Term(Operator operator, Term firstArgument) {
        this.operator = operator;
        this.arguments = new ArrayList();
        this.atom = null;
        this.addArgument(firstArgument);
    }

    public final boolean isAtom() {
        return this.atom != null;
    }

    public final void addArgument(Term term) {
        if (this.isAtom()) {
            throw new IllegalArgumentException("this is an atom, no arguments could be added to " + this.atom.getValue());
        }
        if (this.operator.getMax() >= 0 && this.operator.getMax() < this.arguments.size() + 1) {
            throw new IllegalArgumentException("operator could have maximal " + this.operator.getMax() + " arguments");
        }
        this.arguments.add(term);
    }

    public final Operator getOperator() {
        return this.operator;
    }

    public final int size() {
        if (this.arguments == null) {
            return 0;
        }
        return this.arguments.size();
    }

    public final String getQedeq() {
        if (this.isAtom()) {
            return this.atom.getValue();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.operator.getQedeq()).append('(');
        if (this.operator.getQedeqArgument() != null) {
            buffer.append(IoUtility.quote(this.operator.getQedeqArgument()));
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0 || this.operator.getQedeqArgument() != null) {
                buffer.append(", ");
            }
            buffer.append(((Term)this.arguments.get(i)).getQedeq());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public final String getQedeqXml() {
        return this.getQedeqXml(0);
    }

    private final String getQedeqXml(int level) {
        if (this.isAtom()) {
            return IoUtility.getSpaces(level * 2) + this.atom.getValue() + "\n";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(IoUtility.getSpaces(level * 2));
        buffer.append("<").append(this.operator.getQedeq());
        if (this.operator.getQedeq().endsWith("VAR")) {
            buffer.append(" id=\"" + this.operator.getQedeqArgument() + "\"");
            if (this.arguments == null || this.arguments.size() == 0) {
                buffer.append(" />\n");
                return buffer.toString();
            }
        } else if (this.operator.getQedeq().endsWith("CON")) {
            buffer.append(" ref=\"" + this.operator.getQedeqArgument() + "\"");
            if (this.arguments == null || this.arguments.size() == 0) {
                buffer.append(" />\n");
                return buffer.toString();
            }
        }
        buffer.append(">\n");
        if (this.operator.getQedeqArgument() != null) {
            // empty if block
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            buffer.append(((Term)this.arguments.get(i)).getQedeqXml(level + 1));
        }
        buffer.append(IoUtility.getSpaces(level * 2));
        buffer.append("</").append(this.operator.getQedeq()).append(">\n");
        return buffer.toString();
    }
}

