/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.parser.MathParser;
import org.qedeq.kernel.parser.MementoTextInput;
import org.qedeq.kernel.parser.Operator;
import org.qedeq.kernel.utility.TextInput;

public class SimpleMathParser
extends MathParser {
    private static final String SEPARATORS = "()[],{}";

    public SimpleMathParser(TextInput input, List operators) {
        super(new MementoTextInput(input), operators);
    }

    protected final String readToken() {
        int lines = 0;
        while (this.getChar() != -1 && Character.isWhitespace((char)this.getChar())) {
            if ('\n' == (char)this.getChar()) {
                ++lines;
            }
            this.readChar();
        }
        if (lines > 1) {
            return "";
        }
        if (this.eof()) {
            return null;
        }
        if (SEPARATORS.indexOf(this.getChar()) >= 0) {
            System.out.println("Read token: " + (char)this.getChar());
            return "" + (char)this.readChar();
        }
        StringBuffer token = new StringBuffer();
        while (!this.eof() && !Character.isWhitespace((char)this.getChar()) && SEPARATORS.indexOf(this.getChar()) < 0) {
            token.append((char)this.readChar());
            if (null == this.getOperator(token.toString())) continue;
            if (this.getChar() < 0) break;
            char c = (char)this.getChar();
            if (null != this.getOperator(token.toString() + c)) continue;
        }
        System.out.println("Read token: " + token.toString());
        return token.toString();
    }

    protected final Operator getOperator(String token) {
        Operator result = null;
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result = (Operator)this.getOperators().get(i);
            break;
        }
        return result;
    }

    protected final List getOperators(String token) {
        ArrayList result = new ArrayList();
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result.add(this.getOperators().get(i));
        }
        return result;
    }

    protected boolean eot(String token) {
        return token == null || token.trim().length() == 0;
    }
}

