/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.qedeq.kernel.trace.Trace;

final class ConfigAccess {
    private final File configDirectory;
    private final String configFileName;
    private Properties properties = new Properties();
    private final String description;
    private boolean noTrace = true;

    public ConfigAccess(File configDirectory, String configFileName, String description) throws IOException {
        this.configDirectory = configDirectory;
        this.configFileName = configFileName;
        this.description = description;
        try {
            this.load(new FileInputStream(new File(configDirectory, configFileName)));
        }
        catch (IOException e) {
            Trace.info(this, "ConfigAccess(File, String, String)", "no config file found, using default values");
        }
        this.setString("startDirectory", configDirectory.getCanonicalPath());
        this.setString("configFileLocation", new File(configDirectory, configFileName).getCanonicalPath());
        this.noTrace = false;
    }

    public final File getConfigDirectory() {
        return this.configDirectory;
    }

    public final String getFileName() {
        return this.configFileName;
    }

    public final File getConfigFile() {
        return new File(this.getConfigDirectory(), this.getFileName());
    }

    public final String getConfigDescription() {
        return this.description;
    }

    private final Properties getProperties() {
        return this.properties;
    }

    private final void load(InputStream inStream) throws IOException {
        this.getProperties().load(inStream);
    }

    private final void load(String resource, Class resourceRequestor) throws IOException {
        InputStream stream = resourceRequestor.getResourceAsStream(resource);
        if (stream == null) {
            throw new IOException("ressource was not found: " + resource);
        }
        try {
            this.getProperties().load(stream);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.toString());
        }
    }

    public final void store() throws IOException {
        this.store(this.getConfigFile(), this.getConfigDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void store(File resource, String header) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(resource);
            this.getProperties().store(stream, header);
            Object var5_4 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stream == null) throw throwable;
            try {
                ((OutputStream)stream).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)stream).close();
            return;
        }
        catch (Exception e) {}
    }

    public final String getString(String name) {
        return this.getProperties().getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(String name, String defaultValue) {
        String method = "getString(String, String)";
        try {
            Trace.begin(this, "getString(String, String)");
            Trace.param((Object)this, "getString(String, String)", "name", (Object)name);
            Trace.param((Object)this, "getString(String, String)", "defaultValue", (Object)defaultValue);
            String value = this.getProperties().getProperty(name);
            if (value == null) {
                this.setString(name, defaultValue);
                String string = defaultValue;
                return string;
            }
            String string = value;
            return string;
        }
        finally {
            Trace.end(this, "getString(String, String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setString(String name, String value) {
        String method = "setString(String, String)";
        try {
            if (!this.noTrace) {
                Trace.begin(this, "setString(String, String)");
                Trace.param((Object)this, "setString(String, String)", "name", (Object)name);
                Trace.param((Object)this, "setString(String, String)", "value", (Object)value);
            }
            this.getProperties().setProperty(name, value);
        }
        finally {
            if (!this.noTrace) {
                Trace.end(this, "setString(String, String)");
            }
        }
    }

    public final String[] getStringProperties(String namePrefix) {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration<Object> keys = this.getProperties().keys();
        ArrayList<Object> keyList = Collections.list(keys);
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            if (!key.startsWith(namePrefix)) continue;
            list.add(this.getProperties().get(key));
        }
        return list.toArray(new String[0]);
    }

    public final void setInteger(String name, int value) {
        this.setString(name, "" + value);
    }

    public final int getInteger(String name) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString != null) {
            try {
                return Integer.parseInt(intPropAsString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("int property " + intPropAsString + " has invalid format");
            }
        }
        throw new NullPointerException("property \"" + name + "\" not found");
    }

    public final int getInteger(String name, int defaultValue) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString != null) {
            try {
                return Integer.parseInt(intPropAsString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Integer-Property " + intPropAsString + " has invalid format");
            }
        }
        this.setInteger(name, defaultValue);
        return defaultValue;
    }

    public final void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    public final void removeProperties(String namePrefix) {
        Enumeration<Object> keys = this.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            this.getProperties().remove(key);
        }
    }
}

