/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.qedeq.kernel.common.QedeqException;
import org.qedeq.kernel.common.SourceArea;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.common.SyntaxException;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;
import org.qedeq.kernel.utility.TextInput;
import org.xml.sax.SAXException;

public final class XmlFileException
extends Exception {
    private static final long serialVersionUID = -4109767904038020052L;
    private final int errorCode;
    private final SourceArea errorArea;
    private final SourceArea referenceArea;
    private String line;

    public XmlFileException(QedeqException exception, SourceArea errorArea, SourceArea referenceArea) {
        super(exception);
        this.errorCode = exception.getErrorCode();
        this.errorArea = errorArea;
        this.referenceArea = referenceArea;
    }

    public XmlFileException(SyntaxException exception) {
        super(exception);
        this.errorCode = exception.getErrorCode();
        this.errorArea = new SourceArea(exception.getErrorPosition().getAddress(), exception.getErrorPosition().getLocalAddress(), exception.getErrorPosition(), null);
        this.referenceArea = null;
    }

    public XmlFileException(URL url, Exception exception) {
        super(exception);
        this.errorCode = 9997;
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public XmlFileException(File file, Exception exception) {
        super(exception);
        this.errorCode = 9998;
        URL url = IoUtility.toUrl(file);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public XmlFileException(Exception exception) {
        super(exception);
        this.errorCode = 9999;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public XmlFileException(IOException exception) {
        super(exception);
        this.errorCode = 9997;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public XmlFileException(SAXException exception) {
        super(exception);
        this.errorCode = 9001;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public final SourceArea getSourceArea() {
        return this.errorArea;
    }

    public final SourceArea getReferenceArea() {
        return this.referenceArea;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getLine() {
        if (this.line == null) {
            this.line = "";
            try {
                TextInput input = new TextInput(this.errorArea.getLocalAddress());
                input.setRow(this.errorArea.getStartPosition().getLine());
                input.setColumn(this.errorArea.getStartPosition().getColumn());
                this.line = input.getLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.line;
    }

    public final String getMessage() {
        if (this.getCause() != null) {
            if (this.getCause().getCause() != null) {
                return this.getCause().getCause().getMessage();
            }
            return this.getCause().getMessage();
        }
        return "";
    }

    public final String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorCode() + ": " + this.getMessage());
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append("\n");
            buffer.append(start.getLocalAddress() + ":" + start.getLine() + ":" + start.getColumn());
            buffer.append("\n");
            buffer.append(ReplaceUtility.replace(this.getLine(), "\t", " "));
            buffer.append("\n");
            StringBuffer whitespace = IoUtility.getSpaces(start.getColumn() - 1);
            buffer.append(whitespace);
            buffer.append("^");
        }
        return buffer.toString();
    }

    public final String toString() {
        return this.getDescription();
    }
}

