/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.net.URL;
import org.qedeq.kernel.common.QedeqException;
import org.qedeq.kernel.common.SourcePosition;
import org.xml.sax.SAXParseException;

public final class SyntaxException
extends QedeqException {
    public static final int SAX_PARSER_EXCEPTION = 9001;
    public static final int UNEXPECTED_TAG_CODE = 9002;
    public static final String UNEXPECTED_TAG_TEXT = "Unexpected tag: ";
    public static final int UNEXPECTED_DATA_CODE = 9003;
    public static final String UNEXPECTED_DATA_TEXT = "Unexpected character data in tag: ";
    public static final int MISSING_ATTRIBUTE_CODE = 9004;
    public static final String MISSING_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String MISSING_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int EMPTY_ATTRIBUTE_CODE = 9004;
    public static final String EMPTY_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String EMPTY_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int PROGRAMMING_ERROR_CODE = 9999;
    public static final String PROGRAMMING_ERROR_TEXT = "A programming error occurred.";
    private SourcePosition position;

    private SyntaxException(int code, String message) {
        super(code, message);
    }

    private SyntaxException(int code, String message, RuntimeException e) {
        super(code, message, e);
    }

    private SyntaxException(SAXParseException e, URL url) {
        super(9001, e.getMessage(), e);
        this.position = new SourcePosition(url, e.getLineNumber(), e.getColumnNumber());
    }

    public final SourcePosition getErrorPosition() {
        return this.position;
    }

    public final void setErrorPosition(SourcePosition position) {
        this.position = position;
    }

    public static final SyntaxException createUnexpectedTagException(String name) {
        return new SyntaxException(9002, UNEXPECTED_TAG_TEXT + name);
    }

    public static final SyntaxException createUnexpectedTextDataException(String name, String value) {
        return new SyntaxException(9003, UNEXPECTED_DATA_TEXT + name);
    }

    public static final SyntaxException createMissingAttributeException(String name, String attribute) {
        return new SyntaxException(9004, "Missing attribute: " + attribute + " in tag: " + name);
    }

    public static final SyntaxException createEmptyAttributeException(String name, String attribute) {
        return new SyntaxException(9004, "Missing attribute: " + attribute + " in tag: " + name);
    }

    public static final SyntaxException createBySAXParseException(SAXParseException e, URL url) {
        return new SyntaxException(e, url);
    }

    public static final SyntaxException createByRuntimeException(RuntimeException e) {
        return new SyntaxException(9999, PROGRAMMING_ERROR_TEXT, e);
    }
}

