/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.bo.logic.EqualFormula;

public class EqualFormulaSet {
    private final Set formulas;
    private static final String NULLPOINTER_AS_WORD_IS_NOT_ALLOWED = "NullPointer as element is not allowed";
    private static final String NULLPOINTER_AS_SET_IS_NOT_ALLOWED = "NullPointer as set is not allowed";
    static /* synthetic */ Class class$org$qedeq$kernel$bo$logic$EqualFormulaSet;

    public EqualFormulaSet() {
        this.formulas = new HashSet();
    }

    public EqualFormulaSet(EqualFormula[] formulas) {
        if (formulas == null) {
            throw new IllegalArgumentException("NullPointer as element array is not allowed");
        }
        this.formulas = new HashSet<EqualFormula>(Arrays.asList(formulas));
    }

    EqualFormulaSet(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        this.formulas = new HashSet(set.formulas);
    }

    public EqualFormulaSet(ElementList element) {
        if (element == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_WORD_IS_NOT_ALLOWED);
        }
        if (element.isAtom()) {
            throw new IllegalArgumentException("atom as element is not allowed");
        }
        List list = element.getElements();
        this.formulas = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            this.formulas.add(new EqualFormula((Element)list.get(i)));
        }
    }

    public final boolean contains(EqualFormula formula) {
        if (formula == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_WORD_IS_NOT_ALLOWED);
        }
        return this.formulas.contains(formula);
    }

    public final boolean isEmpty() {
        return this.formulas.isEmpty();
    }

    public final boolean isSubset(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        return this.formulas.containsAll(set.formulas);
    }

    public final EqualFormulaSet add(EqualFormula formula) {
        if (formula == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_WORD_IS_NOT_ALLOWED);
        }
        this.formulas.add(formula);
        return this;
    }

    public final EqualFormulaSet union(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        this.formulas.addAll(set.formulas);
        return this;
    }

    public final EqualFormulaSet remove(EqualFormula formula) {
        if (formula == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_WORD_IS_NOT_ALLOWED);
        }
        this.formulas.remove(formula);
        return this;
    }

    public final EqualFormulaSet minus(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        this.formulas.removeAll(set.formulas);
        return this;
    }

    public final EqualFormulaSet intersection(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        this.formulas.retainAll(set.formulas);
        return this;
    }

    public final EqualFormulaSet newIntersection(EqualFormulaSet set) {
        if (set == null) {
            throw new IllegalArgumentException(NULLPOINTER_AS_SET_IS_NOT_ALLOWED);
        }
        EqualFormulaSet result = new EqualFormulaSet(this);
        result.formulas.retainAll(set.formulas);
        return result;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == (class$org$qedeq$kernel$bo$logic$EqualFormulaSet == null ? (class$org$qedeq$kernel$bo$logic$EqualFormulaSet = EqualFormulaSet.class$("org.qedeq.kernel.bo.logic.EqualFormulaSet")) : class$org$qedeq$kernel$bo$logic$EqualFormulaSet)) {
            return ((Object)this.formulas).equals(((EqualFormulaSet)obj).formulas);
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.formulas).hashCode();
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Iterator iterator = this.formulas.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

