/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import org.qedeq.kernel.base.list.Atom;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.ChapterList;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.Location;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.ProofList;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.SectionList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.SubsectionList;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.control.QedeqBoDuplicateLanguageChecker;
import org.qedeq.kernel.bo.control.QedeqBoFormalLogicChecker;
import org.qedeq.kernel.bo.load.DefaultQedeqBo;
import org.qedeq.kernel.bo.module.IllegalModuleDataException;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.dto.list.DefaultAtom;
import org.qedeq.kernel.dto.list.DefaultElementList;
import org.qedeq.kernel.dto.module.AuthorListVo;
import org.qedeq.kernel.dto.module.AuthorVo;
import org.qedeq.kernel.dto.module.AxiomVo;
import org.qedeq.kernel.dto.module.ChapterListVo;
import org.qedeq.kernel.dto.module.ChapterVo;
import org.qedeq.kernel.dto.module.FormulaVo;
import org.qedeq.kernel.dto.module.FunctionDefinitionVo;
import org.qedeq.kernel.dto.module.HeaderVo;
import org.qedeq.kernel.dto.module.ImportListVo;
import org.qedeq.kernel.dto.module.ImportVo;
import org.qedeq.kernel.dto.module.LatexListVo;
import org.qedeq.kernel.dto.module.LatexVo;
import org.qedeq.kernel.dto.module.LinkListVo;
import org.qedeq.kernel.dto.module.LiteratureItemListVo;
import org.qedeq.kernel.dto.module.LiteratureItemVo;
import org.qedeq.kernel.dto.module.LocationListVo;
import org.qedeq.kernel.dto.module.LocationVo;
import org.qedeq.kernel.dto.module.NodeVo;
import org.qedeq.kernel.dto.module.PredicateDefinitionVo;
import org.qedeq.kernel.dto.module.ProofListVo;
import org.qedeq.kernel.dto.module.ProofVo;
import org.qedeq.kernel.dto.module.PropositionVo;
import org.qedeq.kernel.dto.module.RuleVo;
import org.qedeq.kernel.dto.module.SectionListVo;
import org.qedeq.kernel.dto.module.SectionVo;
import org.qedeq.kernel.dto.module.SpecificationVo;
import org.qedeq.kernel.dto.module.SubsectionListVo;
import org.qedeq.kernel.dto.module.SubsectionVo;
import org.qedeq.kernel.dto.module.TermVo;
import org.qedeq.kernel.dto.module.UsedByListVo;
import org.qedeq.kernel.dto.module.VariableListVo;

public class QedeqBoFactory {
    private DefaultQedeqBo qedeq;
    private Qedeq original;
    private ModuleContext currentContext;

    protected QedeqBoFactory(String globalContext) {
        this.currentContext = new ModuleContext(globalContext);
    }

    public static DefaultQedeqBo createQedeq(String globalContext, Qedeq original) throws ModuleDataException {
        QedeqBoFactory creator = new QedeqBoFactory(globalContext);
        DefaultQedeqBo bo = creator.create(original);
        QedeqBoFormalLogicChecker.check(globalContext, bo);
        QedeqBoDuplicateLanguageChecker.check(globalContext, bo);
        return bo;
    }

    protected final DefaultQedeqBo create(Qedeq original) throws IllegalModuleDataException {
        this.original = original;
        this.getCurrentContext().setLocationWithinModule("");
        if (original == null) {
            this.qedeq = null;
            return this.qedeq;
        }
        this.qedeq = new DefaultQedeqBo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (original.getHeader() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getHeader()");
            this.qedeq.setHeader(this.create(original.getHeader()));
        }
        if (original.getChapterList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getChapterList()");
            this.qedeq.setChapterList(this.create(original.getChapterList()));
        }
        if (original.getLiteratureItemList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getLiteratureItemList()");
            this.qedeq.setLiteratureItemList(this.create(original.getLiteratureItemList()));
        }
        return this.qedeq;
    }

    private final HeaderVo create(Header header) throws IllegalModuleDataException {
        if (header == null) {
            return null;
        }
        HeaderVo h = new HeaderVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (header.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            h.setTitle(this.create(header.getTitle()));
        }
        if (header.getAuthorList() != null) {
            this.setLocationWithinModule(context + ".getAuthorList()");
            h.setAuthorList(this.create(header.getAuthorList()));
        }
        if (header.getSummary() != null) {
            this.setLocationWithinModule(context + ".getSummary()");
            h.setSummary(this.create(header.getSummary()));
        }
        if (header.getEmail() != null) {
            this.setLocationWithinModule(context + ".getEmail()");
            h.setEmail(header.getEmail());
        }
        if (header.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            h.setSpecification(this.create(header.getSpecification()));
        }
        if (header.getImportList() != null) {
            this.setLocationWithinModule(context + ".getImportList()");
            h.setImportList(this.create(header.getImportList()));
        }
        if (header.getUsedByList() != null) {
            this.setLocationWithinModule(context + ".getUsedByList()");
            h.setUsedByList(this.create(header.getUsedByList()));
        }
        this.setLocationWithinModule(context);
        return h;
    }

    private final UsedByListVo create(UsedByList usedByList) {
        if (usedByList == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        UsedByListVo list = new UsedByListVo();
        for (int i = 0; i < usedByList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(usedByList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ImportListVo create(ImportList importList) {
        if (importList == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        ImportListVo list = new ImportListVo();
        for (int i = 0; i < importList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(importList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ImportVo create(Import imp) {
        if (imp == null) {
            return null;
        }
        ImportVo i = new ImportVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (imp.getLabel() != null) {
            this.setLocationWithinModule(context + ".getLabel()");
            i.setLabel(imp.getLabel());
        }
        if (imp.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            i.setSpecification(this.create(imp.getSpecification()));
        }
        this.setLocationWithinModule(context);
        return i;
    }

    private final SpecificationVo create(Specification specification) {
        if (specification == null) {
            return null;
        }
        SpecificationVo s = new SpecificationVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (specification.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            s.setName(specification.getName());
        }
        if (specification.getRuleVersion() != null) {
            this.setLocationWithinModule(context + ".getRuleVersion()");
            s.setRuleVersion(specification.getRuleVersion());
        }
        if (specification.getLocationList() != null) {
            this.setLocationWithinModule(context + ".getLocationList()");
            s.setLocationList(this.create(specification.getLocationList()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final LocationListVo create(LocationList locationList) {
        if (locationList == null) {
            return null;
        }
        LocationListVo list = new LocationListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < locationList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(locationList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final LocationVo create(Location location) {
        if (location == null) {
            return null;
        }
        LocationVo loc = new LocationVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (location.getLocation() != null) {
            this.setLocationWithinModule(context + ".getLocation()");
            loc.setLocation(location.getLocation());
        }
        this.setLocationWithinModule(context);
        return loc;
    }

    private final AuthorListVo create(AuthorList authorList) {
        if (authorList == null) {
            return null;
        }
        AuthorListVo list = new AuthorListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < authorList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(authorList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final AuthorVo create(Author author) {
        if (author == null) {
            return null;
        }
        AuthorVo a = new AuthorVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (author.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            a.setName(this.create(author.getName()));
        }
        if (author.getEmail() != null) {
            this.setLocationWithinModule(context + ".getEmail()");
            a.setEmail(author.getEmail());
        }
        this.setLocationWithinModule(context);
        return a;
    }

    private final ChapterListVo create(ChapterList chapterList) throws IllegalModuleDataException {
        if (chapterList == null) {
            return null;
        }
        ChapterListVo list = new ChapterListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < chapterList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(chapterList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ChapterVo create(Chapter chapter) throws IllegalModuleDataException {
        if (chapter == null) {
            return null;
        }
        ChapterVo c = new ChapterVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (chapter.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            c.setTitle(this.create(chapter.getTitle()));
        }
        if (chapter.getNoNumber() != null) {
            this.setLocationWithinModule(context + ".getNoNumber()");
            c.setNoNumber(chapter.getNoNumber());
        }
        if (chapter.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            c.setIntroduction(this.create(chapter.getIntroduction()));
        }
        if (chapter.getSectionList() != null) {
            this.setLocationWithinModule(context + ".getSectionList()");
            c.setSectionList(this.create(chapter.getSectionList()));
        }
        this.setLocationWithinModule(context);
        return c;
    }

    private LiteratureItemListVo create(LiteratureItemList literatureItemList) throws IllegalModuleDataException {
        if (literatureItemList == null) {
            return null;
        }
        LiteratureItemListVo list = new LiteratureItemListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < literatureItemList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(literatureItemList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private LiteratureItemVo create(LiteratureItem item) throws IllegalModuleDataException {
        if (item == null) {
            return null;
        }
        LiteratureItemVo it = new LiteratureItemVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (item.getLabel() != null) {
            this.setLocationWithinModule(context + ".getLabel()");
            it.setLabel(item.getLabel());
        }
        if (item.getItem() != null) {
            this.setLocationWithinModule(context + ".getItem()");
            it.setItem(this.create(item.getItem()));
        }
        this.setLocationWithinModule(context);
        return it;
    }

    private final SectionListVo create(SectionList sectionList) throws IllegalModuleDataException {
        if (sectionList == null) {
            return null;
        }
        SectionListVo list = new SectionListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < sectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(sectionList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final SectionVo create(Section section) throws IllegalModuleDataException {
        if (section == null) {
            return null;
        }
        SectionVo s = new SectionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (section.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            s.setTitle(this.create(section.getTitle()));
        }
        if (section.getNoNumber() != null) {
            this.setLocationWithinModule(context + ".getNoNumber()");
            s.setNoNumber(section.getNoNumber());
        }
        if (section.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            s.setIntroduction(this.create(section.getIntroduction()));
        }
        if (section.getSubsectionList() != null) {
            this.setLocationWithinModule(context + ".getSubsectionList()");
            s.setSubsectionList(this.create(section.getSubsectionList()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final SubsectionListVo create(SubsectionList subsectionList) throws IllegalModuleDataException {
        if (subsectionList == null) {
            return null;
        }
        SubsectionListVo list = new SubsectionListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < subsectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (subsectionList.get(i) instanceof Subsection) {
                list.add(this.create((Subsection)subsectionList.get(i)));
                continue;
            }
            if (subsectionList.get(i) instanceof Node) {
                list.add(this.create((Node)subsectionList.get(i)));
                continue;
            }
            throw new IllegalArgumentException("unexpected subsection type: " + subsectionList.get(i).getClass());
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final SubsectionVo create(Subsection subsection) {
        if (subsection == null) {
            return null;
        }
        SubsectionVo s = new SubsectionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (subsection.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            s.setTitle(this.create(subsection.getTitle()));
        }
        if (subsection.getLevel() != null) {
            this.setLocationWithinModule(context + ".getLevel()");
            s.setLevel(subsection.getLevel());
        }
        if (subsection.getLatex() != null) {
            this.setLocationWithinModule(context + ".getLatex()");
            s.setLatex(this.create(subsection.getLatex()));
        }
        this.setLocationWithinModule(context);
        return s;
    }

    private final NodeVo create(Node node) throws IllegalModuleDataException {
        if (node == null) {
            return null;
        }
        NodeVo n = new NodeVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (node.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            n.setName(this.create(node.getName()));
        }
        if (node.getId() != null) {
            this.setLocationWithinModule(context + ".getId()");
            n.setId(node.getId());
        }
        if (node.getLevel() != null) {
            this.setLocationWithinModule(context + ".getLevel()");
            n.setLevel(node.getLevel());
        }
        if (node.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            n.setTitle(this.create(node.getTitle()));
        }
        if (node.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            n.setPrecedingText(this.create(node.getPrecedingText()));
        }
        if (node.getNodeType() != null) {
            this.setLocationWithinModule(context + ".getNodeType()");
            if (node.getNodeType() instanceof Axiom) {
                this.setLocationWithinModule(context + ".getNodeType().getAxiom()");
                n.setNodeType(this.create((Axiom)node.getNodeType()));
            } else if (node.getNodeType() instanceof PredicateDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getPredicateDefinition()");
                n.setNodeType(this.create((PredicateDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof FunctionDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getFunctionDefinition()");
                n.setNodeType(this.create((FunctionDefinition)node.getNodeType()));
            } else if (node.getNodeType() instanceof Proposition) {
                this.setLocationWithinModule(context + ".getNodeType().getProposition()");
                n.setNodeType(this.create((Proposition)node.getNodeType()));
            } else if (node.getNodeType() instanceof Rule) {
                this.setLocationWithinModule(context + ".getNodeType().getRule()");
                n.setNodeType(this.create((Rule)node.getNodeType()));
            } else {
                throw new IllegalArgumentException("unexpected node type: " + node.getNodeType().getClass());
            }
        }
        if (node.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            n.setSucceedingText(this.create(node.getSucceedingText()));
        }
        this.setLocationWithinModule(context);
        this.getQedeqCreated().getModuleLabels().addNode(this.getCurrentContext(), n);
        return n;
    }

    private final AxiomVo create(Axiom axiom) {
        if (axiom == null) {
            return null;
        }
        AxiomVo a = new AxiomVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            a.setFormula(this.create(axiom.getFormula()));
        }
        if (axiom.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            a.setDescription(this.create(axiom.getDescription()));
        }
        this.setLocationWithinModule(context);
        return a;
    }

    private final PredicateDefinitionVo create(PredicateDefinition definition) {
        if (definition == null) {
            return null;
        }
        PredicateDefinitionVo d = new PredicateDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            d.setVariableList(this.create(definition.getVariableList()));
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            d.setFormula(this.create(definition.getFormula()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final FunctionDefinitionVo create(FunctionDefinition definition) {
        if (definition == null) {
            return null;
        }
        FunctionDefinitionVo d = new FunctionDefinitionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (definition.getLatexPattern() != null) {
            this.setLocationWithinModule(context + ".getLatexPattern()");
            d.setLatexPattern(definition.getLatexPattern());
        }
        if (definition.getArgumentNumber() != null) {
            this.setLocationWithinModule(context + ".getArgumentNumber()");
            d.setArgumentNumber(definition.getArgumentNumber());
        }
        if (definition.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            d.setName(definition.getName());
        }
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            d.setVariableList(this.create(definition.getVariableList()));
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm()");
            d.setTerm(this.create(definition.getTerm()));
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            d.setDescription(this.create(definition.getDescription()));
        }
        this.setLocationWithinModule(context);
        return d;
    }

    private final PropositionVo create(Proposition proposition) {
        if (proposition == null) {
            return null;
        }
        PropositionVo p = new PropositionVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            p.setFormula(this.create(proposition.getFormula()));
        }
        if (proposition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            p.setDescription(this.create(proposition.getDescription()));
        }
        if (proposition.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            p.setProofList(this.create(proposition.getProofList()));
        }
        this.setLocationWithinModule(context);
        return p;
    }

    private final RuleVo create(Rule rule) {
        if (rule == null) {
            return null;
        }
        RuleVo r = new RuleVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (rule.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            r.setName(rule.getName());
        }
        if (rule.getLinkList() != null) {
            this.setLocationWithinModule(context + ".getLinkList()");
            r.setLinkList(this.create(rule.getLinkList()));
        }
        if (rule.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            r.setDescription(this.create(rule.getDescription()));
        }
        if (rule.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            r.setProofList(this.create(rule.getProofList()));
        }
        this.setLocationWithinModule(context);
        return r;
    }

    private final LinkListVo create(LinkList linkList) {
        if (linkList == null) {
            return null;
        }
        LinkListVo list = new LinkListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < linkList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(linkList.get(i));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final VariableListVo create(VariableList variableList) {
        if (variableList == null) {
            return null;
        }
        VariableListVo list = new VariableListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < variableList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(variableList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ProofListVo create(ProofList proofList) {
        if (proofList == null) {
            return null;
        }
        ProofListVo list = new ProofListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(proofList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final ProofVo create(Proof proof) {
        if (proof == null) {
            return null;
        }
        ProofVo p = new ProofVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        this.setLocationWithinModule(context + ".getKind()");
        p.setKind(proof.getKind());
        this.setLocationWithinModule(context + ".getLevel()");
        p.setLevel(proof.getLevel());
        this.setLocationWithinModule(context);
        if (proof.getNonFormalProof() != null) {
            this.setLocationWithinModule(context + ".getNonFormalProof()");
            p.setNonFormalProof(this.create(proof.getNonFormalProof()));
        }
        this.setLocationWithinModule(context);
        return p;
    }

    private final FormulaVo create(Formula formula) {
        if (formula == null) {
            return null;
        }
        FormulaVo f = new FormulaVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (formula.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            f.setElement(this.create(formula.getElement()));
        }
        this.setLocationWithinModule(context);
        return f;
    }

    private final TermVo create(Term term) {
        if (term == null) {
            return null;
        }
        TermVo f = new TermVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        if (term.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            f.setElement(this.create(term.getElement()));
        }
        this.setLocationWithinModule(context);
        return f;
    }

    private final Element create(Element element) {
        if (element == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (!element.isList()) {
            if (element.isAtom()) {
                return this.create(element.getAtom());
            }
            throw new RuntimeException("unknown element type: " + element);
        }
        this.setLocationWithinModule(context + ".getList()");
        DefaultElementList e = this.create(element.getList());
        this.setLocationWithinModule(context);
        return e;
    }

    private final DefaultElementList create(ElementList list) {
        if (list == null) {
            return null;
        }
        DefaultElementList n = new DefaultElementList(list.getOperator(), new Element[0]);
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < list.size(); ++i) {
            if (list.getElement(i).isList()) {
                this.setLocationWithinModule(context + ".getElement(" + i + ")");
            }
            n.add(this.create(list.getElement(i)));
        }
        this.setLocationWithinModule(context);
        return n;
    }

    private final DefaultAtom create(Atom atom) {
        if (atom == null) {
            return null;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        return new DefaultAtom(atom.getString());
    }

    private final LatexListVo create(LatexList latexList) {
        if (latexList == null) {
            return null;
        }
        LatexListVo list = new LatexListVo();
        String context = this.getCurrentContext().getLocationWithinModule();
        for (int i = 0; i < latexList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            list.add(this.create(latexList.get(i)));
        }
        this.setLocationWithinModule(context);
        return list;
    }

    private final LatexVo create(Latex latex) {
        if (latex == null) {
            return null;
        }
        LatexVo lat = new LatexVo();
        lat.setLanguage(latex.getLanguage());
        lat.setLatex(latex.getLatex());
        return lat;
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    protected final Qedeq getQedeqOriginal() {
        return this.original;
    }

    protected final QedeqBo getQedeqCreated() {
        return this.qedeq;
    }
}

