/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.net.URL;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.QedeqBo;

public class DefaultModuleProperties
implements ModuleProperties {
    private final ModuleAddress address;
    private int loadingCompleteness;
    private LoadingState state;
    private QedeqBo module;
    private Exception exception;

    public DefaultModuleProperties(ModuleAddress address) {
        this.address = address;
        this.state = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
    }

    public final boolean hasFailures() {
        return this.state.isFailure();
    }

    public final String getAddress() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getAddress();
    }

    public final ModuleAddress getModuleAddress() {
        return this.address;
    }

    public final void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public final void setLoadingProgressState(LoadingState state) {
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setCheckedAndLoaded");
        }
        if (this.state == LoadingState.STATE_LOADED) {
            this.module = null;
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState");
        }
        this.exception = null;
        this.state = state;
    }

    public final void setLoadingFailureState(LoadingState state, Exception e) {
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setProgressState");
        }
        if (this.state == LoadingState.STATE_LOADED) {
            this.module = null;
        }
        this.state = state;
        this.exception = e;
    }

    public final LoadingState getLoadingState() {
        return this.state;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final String getStateDescription() {
        if (this.state == LoadingState.STATE_LOADING_FROM_WEB) {
            return this.state.getText() + " (" + this.loadingCompleteness + "%)";
        }
        return this.state.getText();
    }

    public final String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public final String getRuleVersion() {
        if (this.address == null || this.module == null || this.module.getHeader() == null || this.module.getHeader().getSpecification() == null || this.module.getHeader().getSpecification().getRuleVersion() == null) {
            return "null";
        }
        return this.module.getHeader().getSpecification().getRuleVersion();
    }

    public final URL getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getURL();
    }

    public final boolean isLoaded() {
        return this.state == LoadingState.STATE_LOADED;
    }

    public final void setLoaded(QedeqBo module) {
        this.state = LoadingState.STATE_LOADED;
        this.module = module;
    }

    public final QedeqBo getModule() {
        if (this.state != LoadingState.STATE_LOADED) {
            throw new IllegalStateException("module could only be set if state is \"" + LoadingState.STATE_LOADED.getText() + "\"");
        }
        return this.module;
    }

    public final String toString() {
        return super.toString() + ":" + this.address + ";" + this.state;
    }
}

