/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.tracker;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.qedeq.kernel.xml.tracker.XPathLocationParser;
import org.xml.sax.SAXException;

public final class XPathLocationFinder {
    static /* synthetic */ Class class$org$qedeq$kernel$xml$tracker$XPathLocationFinder;

    private XPathLocationFinder() {
    }

    public static final void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        String from = null;
        String xpath = null;
        if (args.length == 0) {
            XPathLocationFinder.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    XPathLocationFinder.printProgramInformation();
                    return;
                }
                if (option.equals("xpath") || option.equals("xp")) {
                    if (i + 1 >= args.length) {
                        XPathLocationFinder.printProgramInformation();
                        System.err.println("\"-xpath\" must be followed by a xpath.");
                        return;
                    }
                    xpath = args[i + 1];
                    ++i;
                    continue;
                }
                XPathLocationFinder.printProgramInformation();
                System.err.println("Unknown option: " + option);
                return;
            }
            from = args[i];
        }
        if (from == null) {
            XPathLocationFinder.printProgramInformation();
            System.err.println("XML file must be specified.");
            return;
        }
        if (xpath == null) {
            XPathLocationFinder.printProgramInformation();
            System.err.println("XPath file must be specified.");
            return;
        }
        System.out.println(IoUtility.getClassName(class$org$qedeq$kernel$xml$tracker$XPathLocationFinder == null ? (class$org$qedeq$kernel$xml$tracker$XPathLocationFinder = XPathLocationFinder.class$("org.qedeq.kernel.xml.tracker.XPathLocationFinder")) : class$org$qedeq$kernel$xml$tracker$XPathLocationFinder) + ", running on: " + KernelContext.getDescriptiveKernelVersion());
        XPathLocationFinder.getXPathLocation(from, xpath);
    }

    public static final SimpleXPath getXPathLocation(String xmlFile, SimpleXPath xpath) throws ParserConfigurationException, SAXException, IOException {
        return XPathLocationFinder.getXPathLocation(xmlFile, xpath.toString());
    }

    public static final SimpleXPath getXPathLocation(String xmlFile, String xpath) throws ParserConfigurationException, SAXException, IOException {
        XPathLocationParser parser = new XPathLocationParser(xpath);
        parser.parse(xmlFile);
        return parser.getFind();
    }

    public static final void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(IoUtility.getClassName(class$org$qedeq$kernel$xml$tracker$XPathLocationFinder == null ? (class$org$qedeq$kernel$xml$tracker$XPathLocationFinder = XPathLocationFinder.class$("org.qedeq.kernel.xml.tracker.XPathLocationFinder")) : class$org$qedeq$kernel$xml$tracker$XPathLocationFinder) + " - find simple XML paths");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("-------------------");
        System.err.println("[-h] -xp[ath] <simpleXPath> <xmlFile>");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program finds the location of a given simple XPath in an XML file.");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h             writes this text and returns");
        System.err.println("-xpath         set the language filter (default: \"en\")");
        System.err.println("<simpleXPath>  simple XML XPath, a subset of the abbreviation XPath notation");
        System.err.println("                \"/element1/element2[3]@attribute\" is an example for such a");
        System.err.println("                notation. This selects from the first occurrence of \"element1\"");
        System.err.println("                and from the third occurrence of subnode \"element2\" the attribute");
        System.err.println("                \"attribute\". The attribute is optional. It is always exactly one");
        System.err.println("                node or the attribute of one node specified.");
        System.err.println("                General syntax:");
        System.err.println("                {<element>\"[\"<index>\"]}+[\"@\"<attribute>]");
        System.err.println("<xmlFile>      XML file");
        System.err.println();
        System.err.println("Parameter Examples");
        System.err.println("------------------");
        System.err.println("-xp QEDEQ/CHAPTER/SECTION/NODE[2]/PRECEDING/AXIOM/FORMULA/FORALL/VAR@id");
        System.err.println("sample/qedeq_basic_concept.xml");
        System.err.println();
        System.err.println("Further information");
        System.err.println("-------------------");
        System.err.println("For more information about *Hilbert II* look at:");
        System.err.println("\thttp://www.qedeq.org/");
        System.err.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

