/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.tracker;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.qedeq.kernel.utility.EqualsUtility;
import org.qedeq.kernel.xml.parser.SourcePosition;

public final class SimpleXPath {
    private final List elements = new ArrayList();
    private final List numbers = new ArrayList();
    private String attribute = null;
    private SourcePosition start;
    private SourcePosition end;

    public SimpleXPath(String xpath) {
        this.init(xpath);
    }

    public SimpleXPath() {
    }

    public SimpleXPath(SimpleXPath original) {
        this.init(original.toString());
    }

    private void init(String xpath) {
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens() && token.indexOf(64) >= 0) {
                this.attribute = token.substring(token.indexOf(64) + 1);
                token = token.substring(0, token.indexOf(64));
            }
            if (token.indexOf(91) < 0) {
                this.elements.add(token);
                this.numbers.add(new Integer(1));
                continue;
            }
            StringTokenizer getnu = new StringTokenizer(token, "[]");
            this.elements.add(getnu.nextToken());
            this.numbers.add(new Integer(getnu.nextToken()));
        }
    }

    public final int size() {
        return this.elements.size();
    }

    public final String getElementName(int i) {
        return (String)this.elements.get(i);
    }

    public final int getElementOccurrence(int i) {
        return (Integer)this.numbers.get(i);
    }

    public final void addElement(String elementName) {
        this.attribute = null;
        this.elements.add(elementName);
        this.numbers.add(new Integer(1));
    }

    public final void addElement(String elementName, int occurrence) {
        this.attribute = null;
        this.elements.add(elementName);
        this.numbers.add(new Integer(occurrence));
    }

    public final String getLastElement() {
        int size = this.elements.size();
        if (size <= 0) {
            return null;
        }
        return (String)this.elements.get(size - 1);
    }

    public final String getBeforeLastElement() {
        int size = this.elements.size();
        if (size <= 1) {
            return null;
        }
        return (String)this.elements.get(size - 2);
    }

    public void deleteLastElement() {
        int size = this.elements.size();
        if (size > 0) {
            this.elements.remove(size - 1);
            this.numbers.remove(size - 1);
            this.attribute = null;
        }
    }

    public final void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    public final void setStartLocation(SourcePosition position) {
        this.start = position;
    }

    public final SourcePosition getStartLocation() {
        return this.start;
    }

    public final void setEndLocation(SourcePosition position) {
        this.end = position;
    }

    public final SourcePosition getEndLocation() {
        return this.end;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof SimpleXPath)) {
            return false;
        }
        SimpleXPath other = (SimpleXPath)obj;
        if (!EqualsUtility.equals(this.getAttribute(), other.getAttribute())) {
            return false;
        }
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!EqualsUtility.equals(this.getElementName(i), other.getElementName(i))) {
                return false;
            }
            if (this.getElementOccurrence(i) == other.getElementOccurrence(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsElements(SimpleXPath other) {
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!EqualsUtility.equals(this.getElementName(i), other.getElementName(i))) {
                return false;
            }
            if (this.getElementOccurrence(i) == other.getElementOccurrence(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean matchesElements(SimpleXPath current, SimpleXPath currentSummary) {
        int size = current.size();
        if (size != this.size()) {
            return false;
        }
        if (size != currentSummary.size()) {
            throw new IllegalArgumentException("summary size doesn't match");
        }
        for (int i = 0; i < size; ++i) {
            if ("*".equals(this.getElementName(i))) {
                if (this.getElementOccurrence(i) == currentSummary.getElementOccurrence(i)) continue;
                return false;
            }
            if (!EqualsUtility.equals(current.getElementName(i), this.getElementName(i))) {
                return false;
            }
            if (current.getElementOccurrence(i) == this.getElementOccurrence(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean matchesElementsBegining(SimpleXPath current, SimpleXPath currentSummary) {
        int size = current.size();
        if (size > this.size()) {
            return false;
        }
        if (size != currentSummary.size()) {
            throw new IllegalArgumentException("summary size doesn't match");
        }
        for (int i = 0; i < size; ++i) {
            if ("*".equals(this.getElementName(i))) {
                if (this.getElementOccurrence(i) == currentSummary.getElementOccurrence(i)) continue;
                return false;
            }
            if (!EqualsUtility.equals(current.getElementName(i), this.getElementName(i))) {
                return false;
            }
            if (current.getElementOccurrence(i) == this.getElementOccurrence(i)) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                buffer.append("/");
            }
            buffer.append(this.getElementName(i));
            if (this.getElementOccurrence(i) == 1) continue;
            buffer.append("[");
            buffer.append(this.getElementOccurrence(i));
            buffer.append("]");
        }
        if (this.getAttribute() != null) {
            buffer.append("@");
            buffer.append(this.getAttribute());
        }
        return buffer.toString();
    }

    public final int hashCode() {
        int code = 0;
        if (this.attribute != null) {
            code ^= this.attribute.hashCode();
        }
        for (int i = 0; i < this.size(); ++i) {
            code ^= i + 1;
            code ^= this.getElementName(i).hashCode();
            code ^= this.getElementOccurrence(i);
        }
        return code;
    }
}

