/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.net.URL;
import org.qedeq.kernel.xml.parser.SourcePosition;
import org.xml.sax.SAXParseException;

public final class SyntaxException
extends Exception {
    public static final int SAX_PARSER_EXCEPTION = 9001;
    public static final int UNEXPECTED_TAG_CODE = 9002;
    public static final String UNEXPECTED_TAG_TEXT = "Unexpected tag: ";
    public static final int UNEXPECTED_DATA_CODE = 9003;
    public static final String UNEXPECTED_DATA_TEXT = "Unexpected character data in tag: ";
    public static final int MISSING_ATTRIBUTE_CODE = 9004;
    public static final String MISSING_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String MISSING_ATTRIBUTE_TEXT_2 = " in tag: ";
    private static final long serialVersionUID = -1356389036916097293L;
    private SourcePosition position;
    private final int errorCode;

    public SyntaxException(SAXParseException e, URL url) {
        super(e);
        this.position = new SourcePosition(url, e.getLineNumber(), e.getColumnNumber());
        this.errorCode = 9001;
    }

    public SyntaxException(int code, String message) {
        super(message);
        this.errorCode = code;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final SourcePosition getErrorPosition() {
        return this.position;
    }

    public final void setErrorPosition(SourcePosition position) {
        this.position = position;
    }

    public static final SyntaxException createUnexpectedTagException(String name) {
        return new SyntaxException(9002, UNEXPECTED_TAG_TEXT + name);
    }

    public static final SyntaxException createUnexpectedTextDataException(String name, String value) {
        return new SyntaxException(9003, UNEXPECTED_DATA_TEXT + name);
    }

    public static final SyntaxException createMissingAttributeException(String name, String attribute) {
        return new SyntaxException(9004, MISSING_ATTRIBUTE_TEXT_1 + attribute + MISSING_ATTRIBUTE_TEXT_2 + name);
    }
}

