/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class SimpleAttributes {
    private Map map = new HashMap();

    public final void add(String key, String value) {
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " already known with value: " + this.map.get(key));
        }
        this.map.put(key, value);
    }

    public final String getString(String key) {
        return (String)this.map.get(key);
    }

    public final Integer getInteger(String key) {
        String value = (String)this.map.get(key);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        return new Integer(value);
    }

    public final Boolean getBoolean(String key) {
        String value = (String)this.map.get(key);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public final Date getDate(String key) {
        String value = (String)this.map.get(key);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date date = formater.parse(value);
            return date;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public final String[] getKeySortedStringValues() {
        TreeMap sorted = new TreeMap(this.map);
        return sorted.values().toArray(new String[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(entry.getKey() + "=\"" + entry.getValue() + "\" ");
        }
        return buffer.toString();
    }
}

