/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ExceptionList {
    private List exceptions = new ArrayList(10);
    public static final int MAXIMUM = 10;

    public final void add(Exception e) throws SAXException {
        if (e == null) {
            NullPointerException ex = new NullPointerException("Exception expected!");
            this.exceptions.add(ex);
            throw ex;
        }
        if (this.size() >= 10) {
            throw new SAXException("Too much errors already occurred.");
        }
        this.exceptions.add(e);
    }

    public final int size() {
        return this.exceptions.size();
    }

    public final Exception get(int i) {
        return (Exception)this.exceptions.get(i);
    }

    public final Exception[] toArray() {
        return this.exceptions.toArray(new Exception[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Exception e;
            if (i != 0) {
                buffer.append("\n");
            }
            if ((e = this.get(i)) instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)e;
                buffer.append(ex.getSystemId() != null ? ex.getPublicId() + " " : "");
                buffer.append(ex.getSystemId() != null ? ex.getSystemId() + " " : "");
                buffer.append(ex.getLineNumber() != -1 ? "Row: " + ex.getLineNumber() + ". " : "");
                buffer.append(ex.getColumnNumber() != -1 ? "Column: " + ex.getColumnNumber() + ". " : "");
                buffer.append(ex.getException() != null ? ex.getException().getMessage() : ex.getMessage());
                continue;
            }
            buffer.append(this.get(i));
        }
        return buffer.toString();
    }
}

