/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.mapper;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.context.ModuleContext;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;
import org.qedeq.kernel.utility.TextInput;
import org.qedeq.kernel.xml.mapper.Context2SimpleXPath;
import org.qedeq.kernel.xml.parser.SourceArea;
import org.qedeq.kernel.xml.parser.SourcePosition;
import org.qedeq.kernel.xml.parser.SyntaxException;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.qedeq.kernel.xml.tracker.XPathLocationFinder;
import org.xml.sax.SAXException;

public final class XmlFilePositionException
extends Exception {
    private static final long serialVersionUID = -4109767904038020052L;
    private final int errorCode;
    private final SourceArea errorArea;
    private final SourceArea referenceArea;
    private String line;
    static /* synthetic */ Class class$org$qedeq$kernel$xml$mapper$XmlFilePositionException;

    public XmlFilePositionException(Qedeq qedeq, ModuleDataException exception) {
        super(exception);
        this.errorCode = exception.getErrorCode();
        this.errorArea = XmlFilePositionException.createSourceArea(qedeq, exception.getContext());
        this.referenceArea = XmlFilePositionException.createSourceArea(qedeq, exception.getReferenceContext());
    }

    public static SourceArea createSourceArea(Qedeq qedeq, ModuleContext context) {
        String xpath;
        String method = "createSourceArea(Qedeq, ModuleContext)";
        if (qedeq == null || context == null) {
            return null;
        }
        try {
            xpath = Context2SimpleXPath.getXPath(context, qedeq).toString();
        }
        catch (ModuleDataException e) {
            Trace.trace(class$org$qedeq$kernel$xml$mapper$XmlFilePositionException == null ? (class$org$qedeq$kernel$xml$mapper$XmlFilePositionException = XmlFilePositionException.class$("org.qedeq.kernel.xml.mapper.XmlFilePositionException")) : class$org$qedeq$kernel$xml$mapper$XmlFilePositionException, "createSourceArea(Qedeq, ModuleContext)", (Throwable)e);
            return null;
        }
        SimpleXPath find = null;
        try {
            find = XPathLocationFinder.getXPathLocation(context.getModuleLocation(), xpath);
            if (find.getStartLocation() == null) {
                return null;
            }
            return new SourceArea(find.getStartLocation().getAddress(), find.getStartLocation().getLocalAddress(), find.getStartLocation(), find.getEndLocation());
        }
        catch (ParserConfigurationException e) {
            Trace.trace(class$org$qedeq$kernel$xml$mapper$XmlFilePositionException == null ? (class$org$qedeq$kernel$xml$mapper$XmlFilePositionException = XmlFilePositionException.class$("org.qedeq.kernel.xml.mapper.XmlFilePositionException")) : class$org$qedeq$kernel$xml$mapper$XmlFilePositionException, "createSourceArea(Qedeq, ModuleContext)", (Throwable)e);
        }
        catch (SAXException e) {
            Trace.trace(class$org$qedeq$kernel$xml$mapper$XmlFilePositionException == null ? (class$org$qedeq$kernel$xml$mapper$XmlFilePositionException = XmlFilePositionException.class$("org.qedeq.kernel.xml.mapper.XmlFilePositionException")) : class$org$qedeq$kernel$xml$mapper$XmlFilePositionException, "createSourceArea(Qedeq, ModuleContext)", (Throwable)e);
        }
        catch (IOException e) {
            Trace.trace(class$org$qedeq$kernel$xml$mapper$XmlFilePositionException == null ? (class$org$qedeq$kernel$xml$mapper$XmlFilePositionException = XmlFilePositionException.class$("org.qedeq.kernel.xml.mapper.XmlFilePositionException")) : class$org$qedeq$kernel$xml$mapper$XmlFilePositionException, "createSourceArea(Qedeq, ModuleContext)", (Throwable)e);
        }
        return null;
    }

    public XmlFilePositionException(SyntaxException exception) {
        super(exception);
        this.errorCode = exception.getErrorCode();
        this.errorArea = new SourceArea(exception.getErrorPosition().getAddress(), exception.getErrorPosition().getLocalAddress(), exception.getErrorPosition(), null);
        this.referenceArea = null;
    }

    public XmlFilePositionException(URL url, Exception exception) {
        super(exception);
        this.errorCode = 9997;
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public XmlFilePositionException(File file, Exception exception) {
        super(exception);
        this.errorCode = 9998;
        URL url = IoUtility.toUrl(file);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public XmlFilePositionException(Exception exception) {
        super(exception);
        this.errorCode = 9999;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public XmlFilePositionException(IOException exception) {
        super(exception);
        this.errorCode = 9997;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public XmlFilePositionException(SAXException exception) {
        super(exception);
        this.errorCode = 9001;
        this.errorArea = null;
        this.referenceArea = null;
    }

    public final SourceArea getSourceArea() {
        return this.errorArea;
    }

    public final SourceArea getReferenceArea() {
        return this.referenceArea;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getLine() {
        if (this.line == null) {
            this.line = "";
            try {
                TextInput input = new TextInput(this.errorArea.getLocalAddress());
                input.setRow(this.errorArea.getStartPosition().getLine());
                input.setColumn(this.errorArea.getStartPosition().getColumn());
                this.line = input.getLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.line;
    }

    public final String getMessage() {
        if (this.getCause() != null) {
            if (this.getCause().getCause() != null) {
                return this.getCause().getCause().getMessage();
            }
            return this.getCause().getMessage();
        }
        return "";
    }

    public final String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorCode() + ": " + this.getMessage());
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append("\n");
            buffer.append(start.getLocalAddress() + ":" + start.getLine() + ":" + start.getColumn());
            buffer.append("\n");
            buffer.append(ReplaceUtility.replace(this.getLine(), "\t", " "));
            buffer.append("\n");
            StringBuffer whitespace = IoUtility.getSpaces(start.getColumn() - 1);
            buffer.append(whitespace);
            buffer.append("^");
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

