/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.handler.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.parser.Operator;
import org.qedeq.kernel.xml.parser.AbstractSimpleHandler;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SimpleAttributes;
import org.qedeq.kernel.xml.parser.SyntaxException;

public final class ParserHandler
extends AbstractSimpleHandler {
    private List operators = new ArrayList();
    private String startSymbol;
    private String qedeq;
    private String qedeqArgument;
    private Integer priority;
    private Integer min;
    private Integer max;

    public ParserHandler(SaxDefaultHandler defaultHandler) {
        super(defaultHandler, "parser");
    }

    public final void init() {
        this.operators.clear();
    }

    public final List getOperators() {
        return this.operators;
    }

    public final void startElement(String name, SimpleAttributes attributes) throws SyntaxException {
        if (!this.getStartTag().equals(name)) {
            if ("prefixOperator".equals(name)) {
                this.setBasisAttributes(attributes);
                this.addOperator(1);
            } else if ("infixOperator".equals(name)) {
                this.setBasisAttributes(attributes);
                this.addOperator(0);
            } else if ("functionOperator".equals(name)) {
                this.setBasisAttributes(attributes);
                this.addOperator(4);
            } else if ("complexOperator".equals(name)) {
                this.setBasisAttributes(attributes);
                String separatorSymbol = attributes.getString("separatorSymbol");
                if (separatorSymbol == null || separatorSymbol.length() == 0) {
                    throw new SyntaxException(100, "Attribute \"separatorSymbol\" is empty");
                }
                String endSymbol = attributes.getString("endSymbol");
                if (endSymbol == null || endSymbol.length() == 0) {
                    throw new SyntaxException(100, "Attribute \"separatorSymbol\" is empty");
                }
                if (this.max == null) {
                    this.operators.add(new Operator(this.startSymbol, separatorSymbol, endSymbol, this.qedeq, this.qedeqArgument, (int)this.priority, (int)this.min));
                } else {
                    this.operators.add(new Operator(this.startSymbol, separatorSymbol, endSymbol, this.qedeq, this.qedeqArgument, this.priority, this.min, this.max));
                }
            } else {
                throw SyntaxException.createUnexpectedTagException(name);
            }
        }
    }

    private void addOperator(int type) {
        if (this.max == null) {
            this.operators.add(new Operator(this.startSymbol, this.qedeq, this.qedeqArgument, this.priority, type, this.min));
        } else {
            this.operators.add(new Operator(this.startSymbol, this.qedeq, this.qedeqArgument, this.priority, type, (int)this.min, (int)this.max));
        }
    }

    private void setBasisAttributes(SimpleAttributes attributes) throws SyntaxException {
        this.startSymbol = attributes.getString("startSymbol");
        if (this.startSymbol == null || this.startSymbol.length() == 0) {
            throw new SyntaxException(100, "Attribute \"symbol\" is empty");
        }
        this.qedeq = attributes.getString("qedeq");
        if (this.qedeq == null || this.qedeq.length() == 0) {
            throw new SyntaxException(100, "Attribute \"qedeq\" is empty");
        }
        this.qedeqArgument = attributes.getString("qedeqArgument");
        this.priority = attributes.getInteger("priority");
        if (this.priority == null || this.priority < 0) {
            throw new SyntaxException(100, "Attribute \"priority\" is empty");
        }
        this.min = attributes.getInteger("min");
        if (this.min == null) {
            this.min = new Integer(0);
        }
        this.max = attributes.getInteger("max");
    }

    public final void endElement(String name) throws SyntaxException {
        if (!(this.getStartTag().equals(name) || "prefixOperator".equals(name) || "infixOperator".equals(name) || "functionOperator".equals(name) || "complexOperator".equals(name))) {
            throw SyntaxException.createUnexpectedTagException(name);
        }
    }
}

