/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.control.QedeqBoFactory;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.latex.Qedeq2Xml;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.TextOutput;
import org.qedeq.kernel.xml.handler.module.QedeqHandler;
import org.qedeq.kernel.xml.mapper.XmlFilePositionException;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.qedeq.kernel.xml.parser.SyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Xml2Xml {
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Xml;
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Latex;

    private Xml2Xml() {
    }

    public static void main(String[] args) {
        String from = null;
        String to = null;
        if (args.length == 0) {
            Xml2Xml.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    Xml2Xml.printProgramInformation();
                    return;
                }
                if (option.equals("to")) {
                    if (i + 1 >= args.length) {
                        Xml2Xml.printArgumentError("\"-to\" must be followed by a filename.");
                        return;
                    }
                    to = args[i + 1];
                    ++i;
                    continue;
                }
                Xml2Xml.printArgumentError("Unknown option: " + option);
                return;
            }
            if (from != null) {
                Xml2Xml.printArgumentError("XML file name must only be specified once.");
                return;
            }
            from = args[i];
        }
        if (from == null) {
            Xml2Xml.printArgumentError("XML file must be specified.");
            return;
        }
        System.out.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml) + ", running on: " + KernelContext.getDescriptiveKernelVersion());
        try {
            System.out.println("Successfully generated:\n" + Xml2Xml.generate(from, to));
        }
        catch (XmlFilePositionException e) {
            System.out.println(e.getDescription());
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    public static void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml) + " - create LaTeX document");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("-------------------");
        System.err.println("[-h] <xmlFile> [-to <latexFile>]");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program creates a XML file out of *Hilbert II* XML files.");
        System.err.println("If no \"-to\" filename was given, the resulting XML file is at the same");
        System.err.println("place as the original file but has the extension \"_.xml\".");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h         writes this text and returns");
        System.err.println("<xmlFile>  XML file that fulfils the XSD from \"http://www.qedeq.org/" + KernelContext.getKernelVersionDirectory() + "\"");
        System.err.println("-to <file> write result into this file");
        System.err.println();
        System.err.println("Parameter Examples");
        System.err.println("------------------");
        System.err.println("sample/qedeq_basic_concept.xml");
        System.err.println();
        System.err.println("Further information");
        System.err.println("-------------------");
        System.err.println("For more information about *Hilbert II* look at:");
        System.err.println("\thttp://www.qedeq.org/");
        System.err.println();
    }

    private static void printArgumentError(String message) {
        System.err.println(">>>ERROR reason:");
        System.err.println(message);
        System.err.println();
        System.err.println(">>>Calling convention:");
        Xml2Xml.printProgramInformation();
    }

    public static String generate(String from, String to) throws XmlFilePositionException {
        return Xml2Xml.generate(from != null ? new File(from) : null, to != null ? new File(to) : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generate(File from, File to) throws XmlFilePositionException {
        Class clazz;
        String string;
        block20: {
            block18: {
                String method = "generate(String, String, String, String)";
                Qedeq qedeq = null;
                try {
                    try {
                        File destination;
                        Trace.begin(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)");
                        Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", "from", (Object)from);
                        Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", "to", (Object)to);
                        File source = from;
                        if (to != null) {
                            destination = to.getCanonicalFile();
                        } else {
                            String xml = source.getName();
                            if (xml.toLowerCase().endsWith(".xml")) {
                                xml = xml.substring(0, xml.length() - 4);
                            }
                            destination = new File(source.getParentFile(), xml + "_.xml").getCanonicalFile();
                        }
                        SaxDefaultHandler handler = new SaxDefaultHandler();
                        QedeqHandler simple = new QedeqHandler(handler);
                        handler.setBasisDocumentHandler(simple);
                        SaxParser parser = new SaxParser(handler);
                        try {
                            parser.parse(source);
                            qedeq = simple.getQedeq();
                        }
                        catch (SAXException ex) {
                            if (parser.getExceptionList().size() <= 0) throw ex;
                            Exception exc = parser.getExceptionList().get(0);
                            if (!(exc instanceof SyntaxException)) throw ex;
                            Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)exc);
                            throw new XmlFilePositionException((SyntaxException)exc);
                        }
                        QedeqBo qedeqBo = QedeqBoFactory.createQedeq(source.getAbsolutePath(), qedeq);
                        IoUtility.createNecessaryDirectories(destination);
                        FileOutputStream outputStream = new FileOutputStream(destination);
                        TextOutput printer = new TextOutput(destination.getName(), outputStream);
                        try {
                            Qedeq2Xml.print(source.getCanonicalPath(), qedeqBo, printer);
                        }
                        catch (ModuleDataException e) {
                            throw new XmlFilePositionException(qedeq, e);
                        }
                        printer.close();
                        string = destination.getCanonicalPath();
                        Object var14_24 = null;
                        if (class$org$qedeq$kernel$rel$test$text$Xml2Xml != null) break block18;
                    }
                    catch (RuntimeException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        throw new XmlFilePositionException(from, (Exception)e);
                    }
                    catch (IOException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        throw new XmlFilePositionException(e);
                    }
                    catch (ModuleDataException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                        Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "context", (Object)e.getContext());
                        throw new XmlFilePositionException(qedeq, e);
                    }
                    catch (ParserConfigurationException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        throw new XmlFilePositionException(e);
                    }
                    catch (SAXParseException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        throw new XmlFilePositionException(e);
                    }
                    catch (SAXException e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        throw new XmlFilePositionException(from, (Exception)e);
                    }
                    catch (FactoryConfigurationError e) {
                        Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)", (Throwable)e);
                        String msg = "SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\".";
                        throw new XmlFilePositionException(new IOException("SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\"."));
                    }
                }
                catch (Throwable throwable) {
                    Object var14_25 = null;
                    Trace.end(class$org$qedeq$kernel$rel$test$text$Xml2Xml == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml")) : class$org$qedeq$kernel$rel$test$text$Xml2Xml, "generate(String, String, String, String)");
                    throw throwable;
                }
                clazz = class$org$qedeq$kernel$rel$test$text$Xml2Xml = Xml2Xml.class$("org.qedeq.kernel.rel.test.text.Xml2Xml");
                break block20;
            }
            clazz = class$org$qedeq$kernel$rel$test$text$Xml2Xml;
        }
        Trace.end(clazz, "generate(String, String, String, String)");
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

