/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.text;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.control.QedeqBoFactory;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.latex.Qedeq2Wiki;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.xml.handler.module.QedeqHandler;
import org.qedeq.kernel.xml.mapper.XmlFilePositionException;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.qedeq.kernel.xml.parser.SyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Xml2Wiki {
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Wiki;
    static /* synthetic */ Class class$org$qedeq$kernel$rel$test$text$Xml2Latex;

    private Xml2Wiki() {
    }

    public static void main(String[] args) {
        String language = null;
        String level = null;
        String from = null;
        String to = null;
        if (args.length == 0) {
            Xml2Wiki.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    Xml2Wiki.printProgramInformation();
                    return;
                }
                if (option.equals("language")) {
                    if (i + 1 >= args.length) {
                        Xml2Wiki.printArgumentError("\"-language\" must be followed by a language.");
                        return;
                    }
                    language = args[i + 1];
                    ++i;
                    continue;
                }
                if (option.equals("level")) {
                    if (i + 1 >= args.length) {
                        Xml2Wiki.printArgumentError("\"-level\" must be followed by a level.");
                        return;
                    }
                    level = args[i + 1];
                    ++i;
                    continue;
                }
                if (option.equals("to")) {
                    if (i + 1 >= args.length) {
                        Xml2Wiki.printArgumentError("\"-to\" must be followed by a filename.");
                        return;
                    }
                    to = args[i + 1];
                    ++i;
                    continue;
                }
                Xml2Wiki.printArgumentError("Unknown option: " + option);
                return;
            }
            if (from != null) {
                Xml2Wiki.printArgumentError("XML file name must only be specified once.");
                return;
            }
            from = args[i];
        }
        if (from == null) {
            Xml2Wiki.printArgumentError("XML file must be specified.");
            return;
        }
        System.out.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki) + ", running on: " + KernelContext.getDescriptiveKernelVersion());
        try {
            Xml2Wiki.generate(from, to, language, level);
            System.out.println("Successfully generated files.");
        }
        catch (XmlFilePositionException e) {
            System.out.println(e.getDescription());
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    public static void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(IoUtility.getClassName(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki) + " - create LaTeX document");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("-------------------");
        System.err.println("[-h] [-language <language>] [-level <level>] <xmlFile> [-to <directory>]");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program creates wiki file(s) out of *Hilbert II* XML files.");
        System.err.println("If no \"-to\" directory was given, the resulting wiki file(s) are placed ");
        System.err.println("at the same directory as the original file.");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h         writes this text and returns");
        System.err.println("-language  set the language filter (default: \"en\")");
        System.err.println("-level     the level filter (default: \"1\")");
        System.err.println("<xmlFile>  XML file that fulfils the XSD from \"http://www.qedeq.org/" + KernelContext.getKernelVersionDirectory() + "\"");
        System.err.println("-to <directory> write result(s) into this directory");
        System.err.println();
        System.err.println("Parameter Examples");
        System.err.println("------------------");
        System.err.println("sample/qedeq_basic_concept.xml");
        System.err.println();
        System.err.println("Further information");
        System.err.println("-------------------");
        System.err.println("For more information about *Hilbert II* look at:");
        System.err.println("\thttp://www.qedeq.org/");
        System.err.println();
    }

    private static void printArgumentError(String message) {
        System.err.println(">>>ERROR reason:");
        System.err.println(message);
        System.err.println();
        System.err.println(">>>Calling convention:");
        Xml2Wiki.printProgramInformation();
    }

    public static void generate(String from, String to, String language, String level) throws XmlFilePositionException {
        Xml2Wiki.generate(from != null ? new File(from) : null, to != null ? new File(to) : null, language, level);
    }

    public static void generate(File from, File to, String language, String level) throws XmlFilePositionException {
        Class clazz;
        String method = "generate(String, String, String, String)";
        Qedeq qedeq = null;
        try {
            try {
                Trace.begin(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)");
                Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", "from", (Object)from);
                Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", "to", (Object)to);
                Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", "language", (Object)language);
                Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", "level", (Object)level);
                File source = from.getCanonicalFile();
                File destination = to != null ? to.getCanonicalFile() : source.getParentFile().getCanonicalFile();
                SaxDefaultHandler handler = new SaxDefaultHandler();
                QedeqHandler simple = new QedeqHandler(handler);
                handler.setBasisDocumentHandler(simple);
                SaxParser parser = new SaxParser(handler);
                try {
                    parser.parse(source);
                    qedeq = simple.getQedeq();
                }
                catch (SAXException ex) {
                    Exception exc;
                    if (parser.getExceptionList().size() > 0 && (exc = parser.getExceptionList().get(0)) instanceof SyntaxException) {
                        throw new XmlFilePositionException((SyntaxException)exc);
                    }
                    throw ex;
                }
                QedeqBo qedeqBo = QedeqBoFactory.createQedeq(source.getAbsolutePath(), qedeq);
                Qedeq2Wiki converter = new Qedeq2Wiki(source.getCanonicalPath(), qedeqBo);
                IoUtility.createNecessaryDirectories(destination);
                converter.printWiki(language, level, destination);
            }
            catch (RuntimeException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                throw new XmlFilePositionException(from, (Exception)e);
            }
            catch (IOException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                throw new XmlFilePositionException(e);
            }
            catch (ModuleDataException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", (Throwable)e);
                Trace.param(class$org$qedeq$kernel$rel$test$text$Xml2Latex == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Latex = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Latex")) : class$org$qedeq$kernel$rel$test$text$Xml2Latex, "generate(String, String, String, String)", "context", (Object)e.getContext());
                throw new XmlFilePositionException(qedeq, e);
            }
            catch (ParserConfigurationException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                throw new XmlFilePositionException(e);
            }
            catch (SAXParseException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                throw new XmlFilePositionException(e);
            }
            catch (SAXException e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                throw new XmlFilePositionException(from, (Exception)e);
            }
            catch (FactoryConfigurationError e) {
                Trace.trace(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)", (Throwable)e);
                String msg = "SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\".";
                throw new XmlFilePositionException(new IOException("SAX Parser not in classpath, add for example \"xercesImpl.jar\" and \"xml-apis.jar\"."));
            }
            Object var14_23 = null;
            clazz = class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            Trace.end(class$org$qedeq$kernel$rel$test$text$Xml2Wiki == null ? (class$org$qedeq$kernel$rel$test$text$Xml2Wiki = Xml2Wiki.class$("org.qedeq.kernel.rel.test.text.Xml2Wiki")) : class$org$qedeq$kernel$rel$test$text$Xml2Wiki, "generate(String, String, String, String)");
            throw throwable;
        }
        Trace.end(clazz, "generate(String, String, String, String)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

