/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.rel.test.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.xml.mapper.XmlFilePositionException;
import org.qedeq.kernel.xml.parser.SourcePosition;

public class QedeqPane
extends JFrame {
    private JTextArea qedeq = new JTextArea();
    private JTextArea error = new JTextArea();
    private JScrollPane qedeqScroller = new JScrollPane();
    private JSplitPane splitPane = new JSplitPane(0);
    private JMenuBar menu = new JMenuBar();
    private final XmlFilePositionException errorPosition;
    private File file;

    public QedeqPane(XmlFilePositionException errorPosition) {
        super("QEDEQ XML File Editor");
        this.errorPosition = errorPosition;
        this.setupView();
        this.updateView();
    }

    private final void setupView() {
        Container pane = this.getContentPane();
        this.qedeq.setDragEnabled(true);
        this.qedeq.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.qedeq.setAutoscrolls(true);
        this.qedeq.setCaretPosition(0);
        this.qedeq.setEditable(false);
        this.qedeq.getCaret().setVisible(false);
        this.qedeq.setLineWrap(true);
        this.qedeq.setWrapStyleWord(true);
        this.qedeq.setFocusable(true);
        this.error.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.error.setAutoscrolls(true);
        this.error.setCaretPosition(0);
        this.error.setEditable(false);
        this.error.getCaret().setVisible(false);
        this.error.setFocusable(true);
        this.error.setForeground(Color.RED);
        this.error.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                QedeqPane.this.updateView();
            }
        });
        JViewport port = this.qedeqScroller.getViewport();
        port.add(this.qedeq);
        JScrollPane errorScroller = new JScrollPane();
        JViewport port2 = errorScroller.getViewport();
        port2.add(this.error);
        pane.setLayout(new BorderLayout(1, 1));
        this.splitPane.setTopComponent(this.qedeqScroller);
        this.splitPane.setBottomComponent(errorScroller);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setOneTouchExpandable(true);
        pane.add(this.splitPane);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Object)this, "componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Object)this, "componentShown", (Object)e);
            }
        });
        this.menu.removeAll();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem save = new JMenuItem("Save");
        save.setMnemonic('S');
        save.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                try {
                    QedeqPane.this.saveQedeq();
                }
                catch (IOException e) {
                    Trace.trace((Object)QedeqPane.this, "actionPerformed", (Throwable)e);
                    JOptionPane.showMessageDialog(QedeqPane.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        fileMenu.add(save);
        this.menu.add(fileMenu);
        this.setJMenuBar(this.menu);
        this.setSize(600, 400);
    }

    public final void setLineWrap(boolean wrap) {
        this.qedeq.setLineWrap(wrap);
    }

    public final boolean getLineWrap() {
        return this.qedeq.getLineWrap();
    }

    public final synchronized void updateView() {
        String method = "updateView()";
        Trace.begin(this, "updateView()");
        if (this.errorPosition != null) {
            try {
                this.file = new File(this.errorPosition.getSourceArea().getLocalAddress().getPath());
                Trace.param((Object)this, "updateView()", "file", (Object)this.file);
                if (this.file.canRead()) {
                    StringBuffer buffer = new StringBuffer();
                    IoUtility.loadFile(this.file, buffer);
                    this.qedeqScroller.getViewport().setViewPosition(new Point(0, 0));
                    this.qedeq.setText(buffer.toString());
                    if (this.file.canWrite()) {
                        this.qedeq.setEditable(true);
                    } else {
                        this.qedeq.setEditable(false);
                    }
                } else {
                    throw new IOException("File " + this.file.getCanonicalPath() + " not readable!");
                }
                this.error.setText(this.errorPosition.getDescription());
                this.error.setCaretPosition(0);
                this.highlightLine();
                this.splitPane.setDividerLocation(this.splitPane.getHeight() - this.splitPane.getDividerSize() - this.error.getFontMetrics(this.error.getFont()).getHeight() * 3 - 4);
                Trace.trace((Object)this, "updateView", (Object)"Text updated");
            }
            catch (IOException ioException) {
                this.qedeq.setEditable(false);
                this.qedeq.setText("");
                this.error.setText("");
                this.splitPane.setDividerLocation(this.getHeight());
                Trace.trace((Object)this, "updateView()", (Throwable)ioException);
            }
        } else {
            this.qedeq.setEditable(false);
            this.qedeq.setText("");
            this.error.setText("");
            this.splitPane.setDividerLocation(this.getHeight());
            Trace.end(this, "updateView()");
        }
        this.repaint();
    }

    public final String getEditedQedeq() {
        if (this.qedeq.isEditable()) {
            return this.qedeq.getText();
        }
        throw new IllegalStateException("no editable qedeq text");
    }

    public final boolean isContentChanged() {
        return !this.qedeq.isEditable();
    }

    public final void saveQedeq() throws IOException {
        IoUtility.saveFile(this.file, this.qedeq.getText());
    }

    private final void highlightLine() {
        int k;
        int j;
        if (this.errorPosition.getCause() instanceof ModuleDataException) {
            int from = this.getAbsolutePosition(this.errorPosition.getSourceArea().getStartPosition());
            int to = this.getAbsolutePosition(this.errorPosition.getSourceArea().getEndPosition());
            this.qedeq.setCaretPosition(0);
            this.qedeq.getCaret().setSelectionVisible(true);
            this.qedeq.setSelectedTextColor(Color.RED);
            this.qedeq.setSelectionColor(Color.YELLOW);
            this.qedeq.setCaretPosition(to);
            this.qedeq.moveCaretPosition(from);
            return;
        }
        SourcePosition startPosition = this.errorPosition.getSourceArea().getStartPosition();
        String method = "highlightLine()";
        Trace.param((Object)this, "highlightLine()", "position", (Object)startPosition);
        try {
            j = this.qedeq.getLineStartOffset(startPosition.getLine() - 1);
        }
        catch (BadLocationException e) {
            Trace.trace((Object)this, "highlightLine()", (Throwable)e);
            j = 0;
        }
        try {
            k = this.qedeq.getLineEndOffset(startPosition.getLine() - 1);
        }
        catch (BadLocationException e) {
            Trace.trace((Object)this, "highlightLine()", (Throwable)e);
            k = this.qedeq.getText().length();
        }
        Trace.trace((Object)this, "highlightLine()", (Object)("from " + j + " to " + k));
        this.qedeq.setCaretPosition(0);
        this.qedeq.getCaret().setSelectionVisible(true);
        this.qedeq.setSelectedTextColor(Color.RED);
        this.qedeq.setSelectionColor(Color.YELLOW);
        this.qedeq.setCaretPosition(j);
        this.qedeq.moveCaretPosition(k);
        if (startPosition.getColumn() > 1) {
            this.qedeq.moveCaretPosition(j + startPosition.getColumn() - 1);
        }
    }

    private int getAbsolutePosition(SourcePosition position) {
        int j;
        try {
            j = this.qedeq.getLineStartOffset(position.getLine() - 1) + position.getColumn() - 1;
        }
        catch (BadLocationException e) {
            Trace.trace((Object)this, "getAbsolutePosition(SourcePosition)", (Throwable)e);
            j = 0;
        }
        return j;
    }
}

