/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.parser.MathParser;
import org.qedeq.kernel.parser.MementoTextInput;
import org.qedeq.kernel.parser.Operator;
import org.qedeq.kernel.utility.TextInput;

public final class AsciiMathParser
extends MathParser {
    private static final String SEPARATORS = "()[],{}";

    public AsciiMathParser(TextInput input, List operators) {
        super(new MementoTextInput(input), operators);
    }

    protected final String readToken() {
        String method = "readToken()";
        int lines = 0;
        while (this.getChar() != -1 && Character.isWhitespace((char)this.getChar())) {
            if ('\n' == (char)this.getChar()) {
                ++lines;
            }
            this.readChar();
        }
        if (lines > 1) {
            return "";
        }
        if (this.eof()) {
            return null;
        }
        if (SEPARATORS.indexOf(this.getChar()) >= 0) {
            Trace.param((Object)this, "readToken()", "Read token", (Object)("" + (char)this.getChar()));
            return "" + (char)this.readChar();
        }
        StringBuffer token = new StringBuffer();
        String operator = null;
        this.markPosition();
        while (!this.eof() && !Character.isWhitespace((char)this.getChar()) && SEPARATORS.indexOf(this.getChar()) < 0) {
            token.append((char)this.readChar());
            if (null == this.getOperator(token.toString())) continue;
            operator = token.toString();
            this.clearMark();
            this.markPosition();
        }
        if (operator != null) {
            this.rewindPosition();
            token.setLength(0);
            token.append(operator);
        } else {
            this.clearMark();
        }
        Trace.param((Object)this, "readToken()", "Read token", (Object)token);
        return token.toString();
    }

    protected final Operator getOperator(String token) {
        Operator result = null;
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result = (Operator)this.getOperators().get(i);
            break;
        }
        return result;
    }

    protected final List getOperators(String token) {
        ArrayList result = new ArrayList();
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result.add(this.getOperators().get(i));
        }
        return result;
    }

    protected boolean eot(String token) {
        return token == null || token.trim().length() == 0;
    }
}

