/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Trace {
    private Trace() {
    }

    public static void trace(Object tracingObject, String method, Object object) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug(object);
        }
    }

    public static void trace(Class tracingClass, String method, Object object) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug(object);
        }
    }

    public static void trace(Object tracingObject, String method, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)throwable, throwable);
        }
    }

    public static void trace(Class tracingClass, String method, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)throwable, throwable);
        }
    }

    public static void trace(Object tracingObject, String method, String description, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)description, throwable);
        }
    }

    public static void trace(Class tracingClass, String method, String description, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)description, throwable);
        }
    }

    public static void begin(Object tracingObject, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)"begin");
        }
    }

    public static void begin(Class tracingClass, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)"begin");
        }
    }

    public static void end(Object tracingObject, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end");
        }
    }

    public static void end(Class tracingClass, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end");
        }
    }

    public static void info(Object tracingObject, String method, String message) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
    }

    public static void info(Class tracingClass, String method, String message) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
    }

    public static void param(Object tracingObject, String method, String param, Object value) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)(param + "=" + value));
        }
    }

    public static void param(Class tracingClass, String method, String param, Object value) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)(param + "=" + value));
        }
    }

    public static void param(Object tracingObject, String method, String param, int value) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)(param + "=" + value));
        }
    }

    public static void param(Class tracingClass, String method, String param, int value) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isDebugEnabled()) {
            log.debug((Object)(param + "=" + value));
        }
    }

    public static void traceStack(Object tracingObject, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            throw new Exception("Stacktrace");
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return;
        }
    }

    public static final void traceStack(Class tracingClass, String method) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            throw new Exception("Stacktrace");
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return;
        }
    }

    public static void paramInfo(Object tracingObject, String method, String param, Object value) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)(param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, String method, String param, Object value) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)(param + "=" + value));
        }
    }

    public static void paramInfo(Object tracingObject, String method, String param, int value) {
        Log log = LogFactory.getFactory().getInstance(tracingObject.getClass() + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)(param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, String method, String param, int value) {
        Log log = LogFactory.getFactory().getInstance(tracingClass + "." + method);
        if (log.isInfoEnabled()) {
            log.info((Object)(param + "=" + value));
        }
    }
}

