/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.latex;

import java.io.IOException;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.Location;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.SubsectionList;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTransverser;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.utility.TextOutput;

public final class Qedeq2Xml
extends AbstractModuleVisitor {
    private QedeqNotNullTransverser transverser;
    private TextOutput printer;
    private QedeqBo qedeq;

    private Qedeq2Xml(QedeqBo qedeq, String globalContext, TextOutput printer) {
        this.qedeq = qedeq;
        this.transverser = new QedeqNotNullTransverser(globalContext, this);
        this.printer = printer;
    }

    public static void print(String globalContext, QedeqBo qedeq, TextOutput printer) throws ModuleDataException, IOException {
        Qedeq2Xml converter = new Qedeq2Xml(qedeq, globalContext, printer);
        converter.printXml();
    }

    private final void printXml() throws IOException, ModuleDataException {
        this.transverser.accept(this.qedeq);
        this.printer.flush();
        if (this.printer.checkError()) {
            throw this.printer.getError();
        }
    }

    public final void visitEnter(Qedeq qedeq) {
        this.printer.levelPrintln("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        this.printer.levelPrintln("<QEDEQ");
        this.printer.levelPrintln("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.printer.levelPrintln("    xsi:noNamespaceSchemaLocation=\"http://www.qedeq.org/" + KernelContext.getKernelVersionDirectory() + "/xml/qedeq.xsd\">");
        this.printer.pushLevel();
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.popLevel();
        this.printer.levelPrintln("</QEDEQ>");
    }

    public void visitEnter(Header header) {
        this.printer.levelPrint("<HEADER");
        if (header.getEmail() != null) {
            this.printer.print(" email=\"" + header.getEmail() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Header header) {
        this.printer.popLevel();
        this.printer.levelPrintln("</HEADER>");
    }

    public void visitEnter(Specification specification) {
        this.printer.levelPrint("<SPECIFICATION");
        if (specification.getName() != null) {
            this.printer.print(" name=\"" + specification.getName() + "\"");
        }
        if (specification.getName() != null) {
            this.printer.print(" ruleVersion=\"" + specification.getRuleVersion() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Specification specification) {
        this.printer.popLevel();
        this.printer.levelPrintln("</SPECIFICATION>");
    }

    public void visitEnter(LatexList latexList) {
        String last = this.transverser.getCurrentContext().getLocationWithinModule();
        if (last.endsWith(".getTitle()")) {
            this.printer.levelPrintln("<TITLE>");
        } else if (last.endsWith(".getSummary()")) {
            this.printer.levelPrintln("<ABSTRACT>");
        } else if (last.endsWith(".getIntroduction()")) {
            this.printer.levelPrintln("<INTRODUCTION>");
        } else if (last.endsWith(".getName()")) {
            this.printer.levelPrintln("<NAME>");
        } else if (last.endsWith(".getPrecedingText()")) {
            this.printer.levelPrintln("<PRECEDING>");
        } else if (last.endsWith(".getSucceedingText()")) {
            this.printer.levelPrintln("<SUCCEEDING>");
        } else if (last.endsWith(".getLatex()")) {
            this.printer.levelPrintln("<TEXT>");
        } else if (last.endsWith(".getDescription()")) {
            this.printer.levelPrintln("<DESCRIPTION>");
        }
        this.printer.pushLevel();
    }

    public void visitLeave(LatexList latexList) {
        this.printer.popLevel();
        String last = this.transverser.getCurrentContext().getLocationWithinModule();
        if (last.endsWith(".getTitle()")) {
            this.printer.levelPrintln("</TITLE>");
        } else if (last.endsWith(".getSummary()")) {
            this.printer.levelPrintln("</ABSTRACT>");
        } else if (last.endsWith(".getIntroduction()")) {
            this.printer.levelPrintln("</INTRODUCTION>");
        } else if (last.endsWith(".getName()")) {
            this.printer.levelPrintln("</NAME>");
        } else if (last.endsWith(".getPrecedingText()")) {
            this.printer.levelPrintln("</PRECEDING>");
        } else if (last.endsWith(".getSucceedingText()")) {
            this.printer.levelPrintln("</SUCCEEDING>");
        } else if (last.endsWith(".getLatex()")) {
            this.printer.levelPrintln("</TEXT>");
        } else if (last.endsWith(".getDescription()")) {
            this.printer.levelPrintln("</DESCRIPTION>");
        }
    }

    public void visitEnter(Latex latex) {
        this.printer.levelPrint("<LATEX");
        if (latex.getLanguage() != null) {
            this.printer.print(" language=\"" + latex.getLanguage() + "\"");
        }
        this.printer.println(">");
        if (latex.getLatex() != null) {
            this.printer.pushLevel();
            this.printer.levelPrintln("<![CDATA[");
            this.printer.pushLevel();
            this.printer.levelPrintln(latex.getLatex());
        }
    }

    public void visitLeave(Latex latex) {
        if (latex.getLatex() != null) {
            this.printer.popLevel();
            this.printer.levelPrintln("]]>");
            this.printer.popLevel();
        }
        this.printer.levelPrintln("</LATEX>");
    }

    public void visitEnter(LocationList locationList) {
        this.printer.levelPrintln("<LOCATIONS>");
        this.printer.pushLevel();
    }

    public void visitLeave(LocationList locationList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</LOCATIONS>");
    }

    public void visitEnter(Location location) {
        this.printer.levelPrint("<LOCATION");
        if (location.getLocation() != null) {
            this.printer.print(" value=\"" + location.getLocation() + "\"");
        }
        this.printer.println(" />");
    }

    public void visitEnter(AuthorList authorList) {
        this.printer.levelPrintln("<AUTHORS>");
        this.printer.pushLevel();
    }

    public void visitLeave(AuthorList authorList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</AUTHORS>");
    }

    public void visitEnter(Author author) {
        this.printer.levelPrint("<AUTHOR");
        if (author.getEmail() != null) {
            this.printer.print(" email=\"" + author.getEmail() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (author.getName() != null) {
            this.printer.levelPrintln("<NAME>");
        }
        this.printer.pushLevel();
    }

    public void visitLeave(Author author) {
        this.printer.popLevel();
        if (author.getName() != null) {
            this.printer.levelPrintln("</NAME>");
        }
        this.printer.popLevel();
        this.printer.levelPrintln("</AUTHOR>");
    }

    public void visitEnter(ImportList importList) {
        this.printer.levelPrintln("<IMPORTS>");
        this.printer.pushLevel();
    }

    public void visitLeave(ImportList importList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</IMPORTS>");
    }

    public void visitEnter(Import imp) {
        this.printer.levelPrint("<IMPORT");
        if (imp.getLabel() != null) {
            this.printer.print(" label=\"" + imp.getLabel() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Import imp) {
        this.printer.popLevel();
        this.printer.levelPrintln("</IMPORT>");
    }

    public void visitEnter(UsedByList usedByList) {
        this.printer.levelPrintln("<USEDBY>");
        this.printer.pushLevel();
    }

    public void visitLeave(UsedByList usedByList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</USEDBY>");
    }

    public void visitEnter(Chapter chapter) {
        this.printer.levelPrint("<CHAPTER");
        if (chapter.getNoNumber() != null) {
            this.printer.print(" noNumber=\"" + chapter.getNoNumber() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Chapter chapter) {
        this.printer.popLevel();
        this.printer.levelPrintln("</CHAPTER>");
    }

    public void visitEnter(Section section) {
        this.printer.levelPrint("<SECTION");
        if (section.getNoNumber() != null) {
            this.printer.print(" noNumber=\"" + section.getNoNumber() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Section section) {
        this.printer.popLevel();
        this.printer.levelPrintln("</SECTION>");
    }

    public void visitEnter(SubsectionList subsectionList) {
        this.printer.levelPrintln("<SUBSECTIONS>");
        this.printer.pushLevel();
    }

    public void visitLeave(SubsectionList subsectionList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</SUBSECTIONS>");
    }

    public void visitEnter(Subsection subsection) {
        this.printer.levelPrint("<SUBSECTION");
        if (subsection.getId() != null) {
            this.printer.print(" id=\"" + subsection.getId() + "\"");
        }
        if (subsection.getLevel() != null) {
            this.printer.print(" level=\"" + subsection.getLevel() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Subsection subsection) {
        this.printer.popLevel();
        this.printer.levelPrintln("</SUBSECTION>");
    }

    public void visitEnter(Node node) {
        this.printer.levelPrint("<NODE");
        if (node.getId() != null) {
            this.printer.print(" id=\"" + node.getId() + "\"");
        }
        if (node.getLevel() != null) {
            this.printer.print(" level=\"" + node.getLevel() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Node node) {
        this.printer.popLevel();
        this.printer.levelPrintln("</NODE>");
    }

    public void visitEnter(Axiom axiom) {
        this.printer.levelPrintln("<AXIOM>");
        this.printer.pushLevel();
    }

    public void visitLeave(Axiom axiom) {
        this.printer.popLevel();
        this.printer.levelPrintln("</AXIOM>");
    }

    public void visitEnter(Proposition proposition) {
        this.printer.levelPrintln("<THEOREM>");
        this.printer.pushLevel();
    }

    public void visitLeave(Proposition proposition) {
        this.printer.popLevel();
        this.printer.levelPrintln("</THEOREM>");
    }

    public void visitEnter(Proof proof) {
        this.printer.levelPrint("<PROOF");
        if (proof.getKind() != null) {
            this.printer.print(" kind=\"" + proof.getKind() + "\"");
        }
        if (proof.getLevel() != null) {
            this.printer.print(" level=\"" + proof.getLevel() + "\"");
        }
        this.printer.println(">");
    }

    public void visitLeave(Proof proof) {
        this.printer.levelPrintln("</PROOF>");
    }

    public void visitEnter(PredicateDefinition definition) {
        this.printer.levelPrint("<DEFINITION_PREDICATE");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + definition.getArgumentNumber() + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + definition.getName() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.levelPrintln("<LATEXPATTERN>" + definition.getLatexPattern() + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(PredicateDefinition definition) {
        this.printer.popLevel();
        this.printer.levelPrintln("</DEFINITION_PREDICATE>");
    }

    public void visitEnter(FunctionDefinition definition) {
        this.printer.levelPrint("<DEFINITION_FUNCTION");
        if (definition.getArgumentNumber() != null) {
            this.printer.print(" arguments=\"" + definition.getArgumentNumber() + "\"");
        }
        if (definition.getName() != null) {
            this.printer.print(" name=\"" + definition.getName() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
        if (definition.getLatexPattern() != null) {
            this.printer.levelPrintln("<LATEXPATTERN>" + definition.getLatexPattern() + "</LATEXPATTERN>");
        }
    }

    public void visitLeave(FunctionDefinition definition) {
        this.printer.popLevel();
        this.printer.levelPrintln("</DEFINITION_FUNCTION>");
    }

    public void visitEnter(Rule rule) {
        this.printer.levelPrint("<RULE");
        if (rule.getName() != null) {
            this.printer.print(" name=\"" + rule.getName() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(Rule rule) {
        this.printer.popLevel();
        this.printer.levelPrintln("</RULE>");
    }

    public void visitEnter(LinkList linkList) {
        for (int i = 0; i < linkList.size(); ++i) {
            this.printer.levelPrint("<LINK");
            if (linkList.get(i) != null) {
                this.printer.print(" id=\"" + linkList.get(i) + "\"");
            }
            this.printer.println("/>");
        }
    }

    public void visitEnter(Formula formula) {
        this.printer.levelPrintln("<FORMULA>");
        this.printer.pushLevel();
    }

    public void visitLeave(Formula formula) {
        this.printer.popLevel();
        this.printer.levelPrintln("</FORMULA>");
    }

    public void visitEnter(Term term) {
        this.printer.levelPrintln("<TERM>");
        this.printer.pushLevel();
    }

    public void visitLeave(Term term) {
        this.printer.popLevel();
        this.printer.levelPrintln("</TERM>");
    }

    public void visitEnter(VariableList variableList) {
        this.printer.levelPrintln("<VARLIST>");
        this.printer.pushLevel();
    }

    public void visitLeave(VariableList variableList) {
        this.printer.popLevel();
        this.printer.levelPrintln("</VARLIST>");
    }

    public void visitEnter(ElementList list) {
        String atom;
        boolean firstIsAtom;
        String operator = list.getOperator();
        this.printer.levelPrint("<" + operator);
        boolean bl = firstIsAtom = list.size() > 0 && list.getElement(0).isAtom();
        if (firstIsAtom && (atom = list.getElement(0).getAtom().getString()) != null) {
            if ("VAR".equals(operator) || "PREDVAR".equals(operator) || "FUNVAR".equals(operator)) {
                this.printer.print(" id=\"" + atom + "\"");
            } else if ("PREDCON".equals(operator) || "FUNCON".equals(operator)) {
                this.printer.print(" ref=\"" + atom + "\"");
            } else {
                this.printer.print(" unknown=\"" + atom + "\"");
            }
        }
        if (list.size() == 0 || list.size() == 1 && list.getElement(0).isAtom()) {
            this.printer.print("/");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(ElementList list) {
        this.printer.popLevel();
        if (list.size() == 0 || list.size() == 1 && list.getElement(0).isAtom()) {
            return;
        }
        this.printer.levelPrintln("</" + list.getOperator() + ">");
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.levelPrintln("<BIBLIOGRAPHY>");
        this.printer.pushLevel();
    }

    public void visitLeave(LiteratureItemList list) {
        this.printer.popLevel();
        this.printer.levelPrintln("</BIBLIOGRAPHY>");
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.levelPrint("<ITEM");
        if (item.getLabel() != null) {
            this.printer.print(" label=\"" + item.getLabel() + "\"");
        }
        this.printer.println(">");
        this.printer.pushLevel();
    }

    public void visitLeave(LiteratureItem item) {
        this.printer.popLevel();
        this.printer.levelPrintln("</ITEM>");
    }
}

