/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.latex;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.SectionList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTransverser;
import org.qedeq.kernel.dto.module.PredicateDefinitionVo;
import org.qedeq.kernel.log.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;
import org.qedeq.kernel.utility.TextOutput;

public final class Qedeq2Latex
extends AbstractModuleVisitor {
    private final QedeqNotNullTransverser transverser;
    private final TextOutput printer;
    private final QedeqBo qedeq;
    private final String language;
    private final String level;
    private final Map predicateDefinitions = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private int chapterNumber;
    private int sectionNumber;
    private String id;
    private String title;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    private Qedeq2Latex(QedeqBo qedeq, String globalContext, TextOutput printer, String language, String level) {
        this.qedeq = qedeq;
        this.transverser = new QedeqNotNullTransverser(globalContext, this);
        this.printer = printer;
        this.language = language == null ? "en" : language;
        this.level = level == null ? "1" : level;
        PredicateDefinitionVo equal = new PredicateDefinitionVo();
        equal.setArgumentNumber("2");
        equal.setName("equal");
        equal.setLatexPattern("#1 \\ =  \\ #2");
        this.predicateDefinitions.put("equal_2", equal);
        PredicateDefinitionVo notEqual = new PredicateDefinitionVo();
        notEqual.setArgumentNumber("2");
        notEqual.setName("notEqual");
        notEqual.setLatexPattern("#1 \\ \\neq  \\ #2");
        this.predicateDefinitions.put("notEqual_2", notEqual);
    }

    public static void print(String globalContext, QedeqBo qedeq, TextOutput printer, String language, String level) throws ModuleDataException, IOException {
        Qedeq2Latex converter = new Qedeq2Latex(qedeq, globalContext, printer, language, level);
        converter.printLatex();
    }

    private final void printLatex() throws IOException, ModuleDataException {
        this.transverser.accept(this.qedeq);
        this.printer.flush();
        if (this.printer.checkError()) {
            throw this.printer.getError();
        }
    }

    public final void visitEnter(Qedeq qedeq) {
        this.printer.println("% -*- TeX:" + this.language.toUpperCase() + " -*-");
        this.printer.println("%%% ====================================================================");
        this.printer.println("%%% @LaTeX-file  " + this.printer.getName());
        this.printer.println("%%% Generated at " + this.getTimestamp());
        this.printer.println("%%% ====================================================================");
        this.printer.println();
        this.printer.println("%%% Permission is granted to copy, distribute and/or modify this document");
        this.printer.println("%%% under the terms of the GNU Free Documentation License, Version 1.2");
        this.printer.println("%%% or any later version published by the Free Software Foundation;");
        this.printer.println("%%% with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.");
        this.printer.println();
        this.printer.println("\\documentclass[a4paper,german,10pt,twoside]{book}");
        if ("de".equals(this.language)) {
            this.printer.println("\\usepackage[german]{babel}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\usepackage[english]{babel}");
        }
        this.printer.println("\\usepackage{makeidx}");
        this.printer.println("\\usepackage{amsmath,amsthm,amssymb}");
        this.printer.println("\\usepackage{color}");
        this.printer.println("\\usepackage[bookmarks,bookmarksnumbered,bookmarksopen,");
        this.printer.println("   colorlinks,linkcolor=webgreen,pagebackref]{hyperref}");
        this.printer.println("\\definecolor{webgreen}{rgb}{0,.5,0}");
        this.printer.println("\\usepackage{graphicx}");
        this.printer.println("\\usepackage{xr}");
        this.printer.println("\\usepackage{epsfig,longtable}");
        this.printer.println("\\usepackage{tabularx}");
        this.printer.println();
        if ("de".equals(this.language)) {
            this.printer.println("\\newtheorem{thm}{Theorem}[chapter]");
            this.printer.println("\\newtheorem{cor}[thm]{Korollar}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Regel}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}[thm]{Definition}");
            this.printer.println("\\newtheorem{idefn}[thm]{Initiale Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Bemerkung}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\newtheorem{thm}{Theorem}[chapter]");
            this.printer.println("\\newtheorem{cor}[thm]{Corollary}");
            this.printer.println("\\newtheorem{lem}[thm]{Lemma}");
            this.printer.println("\\newtheorem{prop}[thm]{Proposition}");
            this.printer.println("\\newtheorem{ax}{Axiom}");
            this.printer.println("\\newtheorem{rul}{Rule}");
            this.printer.println();
            this.printer.println("\\theoremstyle{definition}");
            this.printer.println("\\newtheorem{defn}[thm]{Definition}");
            this.printer.println("\\newtheorem{idefn}[thm]{Initial Definition}");
            this.printer.println();
            this.printer.println("\\theoremstyle{remark}");
            this.printer.println("\\newtheorem{rem}[thm]{Remark}");
            this.printer.println("\\newtheorem*{notation}{Notation}");
        }
        this.printer.println();
        this.printer.println("\\addtolength{\\textheight}{7\\baselineskip}");
        this.printer.println("\\addtolength{\\topmargin}{-5\\baselineskip}");
        this.printer.println();
        this.printer.println("\\setlength{\\parindent}{0pt}");
        this.printer.println();
        this.printer.println("\\frenchspacing \\sloppy");
        this.printer.println();
        this.printer.println("\\makeindex");
        this.printer.println();
        this.printer.println();
    }

    public final void visitLeave(Qedeq qedeq) {
        this.printer.println("\\backmatter");
        this.printer.println();
        this.printer.println("\\addcontentsline{toc}{chapter}{\\indexname} \\printindex");
        this.printer.println();
        this.printer.println("\\end{document}");
        this.printer.println();
    }

    public void visitEnter(Header header) {
        LatexList title = header.getTitle();
        this.printer.print("\\title{");
        this.printer.print(this.getLatexListEntry(title));
        this.printer.println("}");
        this.printer.println("\\author{");
        AuthorList authors = this.qedeq.getHeader().getAuthorList();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                this.printer.println(", ");
            }
            Author author = authors.get(i);
            this.printer.print(author.getName().getLatex());
        }
        this.printer.println();
        this.printer.println("}");
        this.printer.println();
        this.printer.println("\\begin{document}");
        this.printer.println();
        this.printer.println("\\maketitle");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println("\\mbox{}");
        this.printer.println("\\vfill");
        this.printer.println();
        String url = this.getUrl(header.getSpecification());
        if (url != null && url.length() > 0) {
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Die Quelle f{\"ur} dieses Dokument ist hier zu finden:");
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("The source for this document can be found here:");
            }
            this.printer.println("\\par");
            this.printer.println("\\url{" + this.getUrl(header.getSpecification()) + "}");
            this.printer.println();
        }
        this.printer.println("\\par");
        if ("de".equals(this.language)) {
            this.printer.println("Die vorliegende Publikation ist urheberrechtlich gesch{\"u}tzt.");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Copyright by the authors. All rights reserved.");
        }
        String email = header.getEmail();
        if (email != null && email.length() > 0) {
            String emailUrl = "\\url{mailto:" + email + "}";
            this.printer.println("\\par");
            if ("de".equals(this.language)) {
                this.printer.println("Bei Fragen, Anregungen oder Bitte um Aufnahme in die Liste der abh{\"a}ngigen Module schicken Sie bitte eine EMail an die Addresse " + emailUrl);
            } else {
                if (!"en".equals(this.language)) {
                    this.printer.println("%%% TODO unknown language: " + this.language);
                }
                this.printer.println("If you have any questions, suggestions or want to add something to the list of modules that use this one, please send an email to the address " + emailUrl);
            }
            this.printer.println();
        }
        this.printer.println("\\setlength{\\parskip}{0pt}");
        this.printer.println("\\tableofcontents");
        this.printer.println();
        this.printer.println("\\setlength{\\parskip}{5pt plus 2pt minus 1pt}");
        this.printer.println();
    }

    private String getUrl(Specification specification) {
        LocationList list = specification.getLocationList();
        if (list == null || list.size() <= 0 || list.get(0).getLocation().length() <= "http://a.b".length()) {
            return "";
        }
        String location = list.get(0).getLocation();
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        location = location + specification.getName();
        location = location + ".xml";
        return location;
    }

    public void visitEnter(Chapter chapter) {
        this.printer.print("\\chapter");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.print("*");
        }
        this.printer.print("{");
        this.printer.print(this.getLatexListEntry(chapter.getTitle()));
        String label = "chapter" + this.chapterNumber;
        this.printer.println("} \\label{" + label + "} \\hypertarget{" + label + "}{}");
        if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
            this.printer.println("\\addcontentsline{toc}{chapter}{" + this.getLatexListEntry(chapter.getTitle()) + "}");
        }
        this.printer.println();
        if (chapter.getIntroduction() != null) {
            this.printer.println(this.getLatexListEntry(chapter.getIntroduction()));
            this.printer.println();
        }
    }

    public void visitLeave(Chapter chapter) {
        this.printer.println("%% end of chapter " + this.getLatexListEntry(chapter.getTitle()));
        this.printer.println();
        ++this.chapterNumber;
        this.sectionNumber = 0;
    }

    public void visitLeave(SectionList list) {
        this.printer.println();
    }

    public void visitEnter(Section section) {
        this.printer.print("\\section{");
        this.printer.print(this.getLatexListEntry(section.getTitle()));
        String label = "chapter" + this.chapterNumber + "_section" + this.sectionNumber;
        this.printer.println("} \\label{" + label + "} \\hypertarget{" + label + "}{}");
        this.printer.println(this.getLatexListEntry(section.getIntroduction()));
        this.printer.println();
    }

    public void visitLeave(Section section) {
        ++this.sectionNumber;
    }

    public void visitEnter(Subsection subsection) {
        if (subsection.getTitle() != null) {
            this.printer.print("\\subsection{");
            this.printer.println(this.getLatexListEntry(subsection.getTitle()));
            this.printer.println("}");
        }
        if (subsection.getId() != null) {
            this.printer.println("\\label{" + subsection.getId() + "} \\hypertarget{" + subsection.getId() + "}{}");
        }
        this.printer.println(this.getLatexListEntry(subsection.getLatex()));
    }

    public void visitLeave(Subsection subsection) {
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Node node) {
        this.printer.println("\\par");
        this.printer.println(this.getLatexListEntry(node.getPrecedingText()));
        this.printer.println();
        this.id = node.getId();
        this.title = null;
        if (node.getTitle() != null) {
            this.title = this.getLatexListEntry(node.getTitle());
        }
    }

    public void visitLeave(Node node) {
        this.printer.println();
        this.printer.println(this.getLatexListEntry(node.getSucceedingText()));
        this.printer.println();
        this.printer.println();
    }

    public void visitEnter(Axiom axiom) {
        this.printer.println("\\begin{ax}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println(this.getLatexListEntry(axiom.getDescription()));
        this.printer.println("\\end{ax}");
    }

    public void visitEnter(Proposition proposition) {
        this.printer.println("\\begin{prop}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        this.printTopFormula(proposition.getFormula().getElement(), this.id);
        this.printer.println(this.getLatexListEntry(proposition.getDescription()));
        this.printer.println("\\end{prop}");
    }

    public void visitEnter(Proof proof) {
        this.printer.println("\\begin{proof}");
        this.printer.println(this.getLatexListEntry(proof.getNonFormalProof()));
        this.printer.println("\\end{proof}");
    }

    public void visitEnter(PredicateDefinition definition) {
        StringBuffer define = new StringBuffer("$$" + definition.getLatexPattern());
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace((Object)this, "printPredicateDefinition", (Object)"replacing!");
                ReplaceUtility.replace(define, "#" + (i + 1), this.getLatex(list.get(i)));
            }
        }
        if (definition.getFormula() != null) {
            this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
            this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
            define.append("\\ :\\leftrightarrow \\ ");
            define.append(this.getLatex(definition.getFormula().getElement()));
        } else {
            this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
            this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        }
        define.append("$$");
        this.predicateDefinitions.put(definition.getName() + "_" + definition.getArgumentNumber(), definition);
        Trace.param((Object)this, "printPredicateDefinition", "define", (Object)define);
        this.printer.println(define);
        this.printer.println(this.getLatexListEntry(definition.getDescription()));
        if (definition.getFormula() != null) {
            this.printer.println("\\end{defn}");
        } else {
            this.printer.println("\\end{idefn}");
        }
    }

    public void visitEnter(FunctionDefinition definition) {
        StringBuffer define = new StringBuffer("$$" + definition.getLatexPattern());
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace((Object)this, "printFunctionDefinition", (Object)"replacing!");
                ReplaceUtility.replace(define, "#" + (i + 1), this.getLatex(list.get(i)));
            }
        }
        if (definition.getTerm() != null) {
            this.printer.println("\\begin{defn}" + (this.title != null ? "[" + this.title + "]" : ""));
            this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
            define.append("\\ := \\ ");
            define.append(this.getLatex(definition.getTerm().getElement()));
        } else {
            this.printer.println("\\begin{idefn}" + (this.title != null ? "[" + this.title + "]" : ""));
            this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        }
        define.append("$$");
        this.functionDefinitions.put(definition.getName() + "_" + definition.getArgumentNumber(), definition);
        Trace.param((Object)this, "printFunctionDefinition", "define", (Object)define);
        this.printer.println(define);
        this.printer.println(this.getLatexListEntry(definition.getDescription()));
        if (definition.getTerm() != null) {
            this.printer.println("\\end{defn}");
        } else {
            this.printer.println("\\end{idefn}");
        }
    }

    public void visitLeave(FunctionDefinition definition) {
    }

    public void visitEnter(Rule rule) {
        this.printer.println("\\begin{rul}" + (this.title != null ? "[" + this.title + "]" : ""));
        this.printer.println("\\label{" + this.id + "} \\hypertarget{" + this.id + "}{}");
        this.printer.println(this.getLatexListEntry(rule.getDescription()));
        this.printer.println("\\end{rul}");
        if (rule.getProofList() != null) {
            for (int i = 0; i < rule.getProofList().size(); ++i) {
                this.printer.println("\\begin{proof}");
                this.printer.println(this.getLatexListEntry(rule.getProofList().get(i).getNonFormalProof()));
                this.printer.println("\\end{proof}");
            }
        }
    }

    public void visitLeave(Rule rule) {
    }

    public void visitEnter(LinkList linkList) {
        if (linkList.size() <= 0) {
            return;
        }
        if ("de".equals(this.language)) {
            this.printer.println("Basierend auf: ");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("Based on: ");
        }
        for (int i = 0; i < linkList.size(); ++i) {
            if (linkList.get(i) == null) continue;
            this.printer.print(" \\ref{" + linkList.get(i) + "}");
        }
        this.printer.println();
    }

    public void visitEnter(LiteratureItemList list) {
        this.printer.println("\\begin{thebibliography}{99}");
        if ("de".equals(this.language)) {
            this.printer.println("\\addcontentsline{toc}{chapter}{Literaturverzeichnis}");
        } else {
            if (!"en".equals(this.language)) {
                this.printer.println("%%% TODO unknown language: " + this.language);
            }
            this.printer.println("\\addcontentsline{toc}{chapter}{Bibliography}");
        }
        ImportList imports = this.qedeq.getHeader().getImportList();
        if (imports != null && imports.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Used other QEDEQ modules:");
            for (int i = 0; i < imports.size(); ++i) {
                Import imp = imports.get(i);
                this.printer.print("\\bibitem{" + imp.getLabel() + "} ");
                Specification spec = imp.getSpecification();
                this.printer.print(this.getLatex(spec.getName()));
                if (spec.getLocationList() != null && spec.getLocationList().size() > 0 && spec.getLocationList().get(0).getLocation().length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + spec.getLocationList().get(0).getLocation() + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
            this.printer.println("%% Other references:");
            this.printer.println();
        }
    }

    public void visitLeave(LiteratureItemList list) {
        UsedByList usedby = this.qedeq.getHeader().getUsedByList();
        if (usedby != null && usedby.size() > 0) {
            this.printer.println();
            this.printer.println();
            this.printer.println("%% QEDEQ modules that use this one:");
            for (int i = 0; i < usedby.size(); ++i) {
                Specification spec = usedby.get(i);
                this.printer.print("\\bibitem{" + spec.getName() + "} ");
                this.printer.print(this.getLatex(spec.getName()));
                String url = this.getUrl(spec);
                if (url != null && url.length() > 0) {
                    this.printer.print(" ");
                    this.printer.print("\\url{" + url + "}");
                }
                this.printer.println();
            }
            this.printer.println();
            this.printer.println();
        }
        this.printer.println("\\end{thebibliography}");
    }

    public void visitEnter(LiteratureItem item) {
        this.printer.print("\\bibitem{" + item.getLabel() + "} ");
        this.printer.println(this.getLatexListEntry(item.getItem()));
        this.printer.println();
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{0.9\\linewidth}l}}");
        for (int i = 0; i < list.size(); ++i) {
            String label = i < ALPHABET.length() ? "" + ALPHABET.charAt(i) : "" + i;
            this.printer.println("\\centering $" + this.getLatex(list.getElement(i)) + "$" + " & \\label{" + mainLabel + ":" + label + "} \\hypertarget{" + mainLabel + ":" + label + "}{} \\mbox{\\emph{(" + label + ")}} " + (i + 1 < list.size() ? "\\\\" : ""));
        }
        this.printer.println("\\end{longtable}");
    }

    private void printFormula(Element element) {
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{\\linewidth}}}");
        this.printer.println("\\centering $" + this.getLatex(element) + "$");
        this.printer.println("\\end{longtable}");
    }

    private String getLatex(Element element) {
        return this.getLatex(element, true);
    }

    private String getLatex(Element element, boolean first) {
        StringBuffer buffer = new StringBuffer();
        if (element.isAtom()) {
            return element.getAtom().getString();
        }
        ElementList list = element.getList();
        if (list.getOperator().equals("PREDCON")) {
            String identifier = list.getElement(0).getAtom().getString() + "_" + (list.size() - 1);
            if (this.predicateDefinitions.containsKey(identifier)) {
                PredicateDefinition definition = (PredicateDefinition)this.predicateDefinitions.get(identifier);
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    ReplaceUtility.replace(define, "#" + i, this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        } else if (list.getOperator().equals("PREDVAR")) {
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        } else if (list.getOperator().equals("FUNCON")) {
            String identifier = list.getElement(0).getAtom().getString() + "_" + (list.size() - 1);
            if (this.functionDefinitions.containsKey(identifier)) {
                FunctionDefinition definition = (FunctionDefinition)this.functionDefinitions.get(identifier);
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    ReplaceUtility.replace(define, "#" + i, this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        } else if (list.getOperator().equals("FUNVAR")) {
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        } else {
            if (list.getOperator().equals("VAR")) {
                String text = list.getElement(0).getAtom().getString();
                try {
                    int index = Integer.parseInt(text);
                    String newText = "" + index;
                    if (!text.equals(newText) || newText.startsWith("-")) {
                        throw new NumberFormatException("This is no allowed number: " + text);
                    }
                    switch (index) {
                        case 1: {
                            return "x";
                        }
                        case 2: {
                            return "y";
                        }
                        case 3: {
                            return "z";
                        }
                        case 4: {
                            return "u";
                        }
                        case 5: {
                            return "v";
                        }
                        case 6: {
                            return "w";
                        }
                    }
                    return "x_" + (index - 6);
                }
                catch (NumberFormatException e) {
                    return text;
                }
            }
            if (list.getOperator().equals("AND") || list.getOperator().equals("OR") || list.getOperator().equals("EQUI") || list.getOperator().equals("IMPL")) {
                String infix = list.getOperator().equals("AND") ? "\\ \\land \\ " : (list.getOperator().equals("OR") ? "\\ \\lor \\ " : (list.getOperator().equals("EQUI") ? "\\ \\leftrightarrow \\ " : "\\ \\rightarrow \\ "));
                if (!first) {
                    buffer.append("(");
                }
                for (int i = 0; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(infix);
                }
                if (!first) {
                    buffer.append(")");
                }
            } else if (list.getOperator().equals("FORALL") || list.getOperator().equals("EXISTS") || list.getOperator().equals("EXISTSU")) {
                String prefix = list.getOperator().equals("FORALL") ? "\\forall " : (list.getOperator().equals("EXISTS") ? "\\exists " : "\\exists! ");
                buffer.append(prefix);
                for (int i = 0; i < list.size(); ++i) {
                    if (i != 0 || i == 0 && list.size() <= 2) {
                        buffer.append(this.getLatex(list.getElement(i), false));
                    }
                    if (i + 1 < list.size()) {
                        buffer.append("\\ ");
                    }
                    if (list.size() <= 2 || i != 1) continue;
                    buffer.append("\\ ");
                }
            } else if (list.getOperator().equals("NOT")) {
                String prefix = "\\neg ";
                buffer.append("\\neg ");
                for (int i = 0; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                }
            } else if (list.getOperator().equals("CLASS")) {
                String prefix = "\\{ ";
                buffer.append("\\{ ");
                for (int i = 0; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(" \\ | \\ ");
                }
                buffer.append(" \\} ");
            } else if (list.getOperator().equals("CLASSLIST")) {
                String prefix = "\\{ ";
                buffer.append("\\{ ");
                for (int i = 0; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", \\ ");
                }
                buffer.append(" \\} ");
            } else if (list.getOperator().equals("QUANTOR_INTERSECTION")) {
                String prefix = "\\bigcap";
                buffer.append("\\bigcap");
                if (0 < list.size()) {
                    buffer.append("{").append(this.getLatex(list.getElement(0), false)).append("}");
                }
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(" \\ \\ ");
                }
                buffer.append(" \\} ");
            } else if (list.getOperator().equals("QUANTOR_UNION")) {
                String prefix = "\\bigcup";
                buffer.append("\\bigcup");
                if (0 < list.size()) {
                    buffer.append("{").append(this.getLatex(list.getElement(0), false)).append("}");
                }
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(" \\ \\ ");
                }
                buffer.append(" \\} ");
            } else {
                buffer.append(list.getOperator());
                buffer.append("(");
                for (int i = 0; i < list.size(); ++i) {
                    buffer.append(this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    private String getTimestamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss,SSS");
        return formatter.format(new Date());
    }

    private String getLatexListEntry(LatexList list) {
        int i;
        if (list == null) {
            return "";
        }
        for (i = 0; i < list.size(); ++i) {
            if (!this.language.equals(list.get(i).getLanguage())) continue;
            return this.getLatex(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i).getLanguage() != null) continue;
            return this.getLatex(list.get(i));
        }
        i = 0;
        if (i < list.size()) {
            return "MISSING! OTHER: " + this.getLatex(list.get(i));
        }
        return "MISSING!";
    }

    private String getLatex(Latex latex) {
        return this.escapeUmlauts(latex.getLatex());
    }

    private String getLatex(String text) {
        StringBuffer buffer = new StringBuffer(text);
        IoUtility.deleteLineLeadingWhitespace(buffer);
        ReplaceUtility.replace(buffer, "\\", "\\textbackslash");
        ReplaceUtility.replace(buffer, "$", "\\$");
        ReplaceUtility.replace(buffer, "&", "\\&");
        ReplaceUtility.replace(buffer, "%", "\\%");
        ReplaceUtility.replace(buffer, "#", "\\#");
        ReplaceUtility.replace(buffer, "_", "\\_");
        ReplaceUtility.replace(buffer, "{", "\\{");
        ReplaceUtility.replace(buffer, "}", "\\}");
        ReplaceUtility.replace(buffer, "~", "\\textasciitilde");
        ReplaceUtility.replace(buffer, "^", "\\textasciicircum");
        ReplaceUtility.replace(buffer, "<", "\\textless");
        ReplaceUtility.replace(buffer, ">", "\\textgreater");
        ReplaceUtility.replace(buffer, "\u00fc", "{\\\"u}");
        ReplaceUtility.replace(buffer, "\u00f6", "{\\\"o}");
        ReplaceUtility.replace(buffer, "\u00e4", "{\\\"a}");
        ReplaceUtility.replace(buffer, "\u00dc", "{\\\"U}");
        ReplaceUtility.replace(buffer, "\u00d6", "{\\\"O}");
        ReplaceUtility.replace(buffer, "\u00c4", "{\\\"A}");
        ReplaceUtility.replace(buffer, "\u00df", "{\\ss}");
        return buffer.toString();
    }

    private String escapeUmlauts(String nearlyLatex) {
        if (nearlyLatex == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(nearlyLatex);
        IoUtility.deleteLineLeadingWhitespace(buffer);
        ReplaceUtility.replace(buffer, "\u00fc", "{\\\"u}");
        ReplaceUtility.replace(buffer, "\u00f6", "{\\\"o}");
        ReplaceUtility.replace(buffer, "\u00e4", "{\\\"a}");
        ReplaceUtility.replace(buffer, "\u00dc", "{\\\"U}");
        ReplaceUtility.replace(buffer, "\u00d6", "{\\\"O}");
        ReplaceUtility.replace(buffer, "\u00c4", "{\\\"A}");
        ReplaceUtility.replace(buffer, "\u00df", "{\\ss}");
        return buffer.toString();
    }
}

